#ifndef __INCLUDED_DIA_PROPERTY_BAG_REGISTRY__
#define __INCLUDED_DIA_PROPERTY_BAG_REGISTRY__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_PROPERTY_BAG__
#include "dia_PropertyBag.h"
#endif

#define REGISTRY_MAX_ENTRY_LENGTH            ((tU8)(240)) /*Bytes*/

class dia_PropertyBagRegistry
    : public dia_PropertyBag
{
public:
    //! this is the only class constructor subclasses can use
    dia_PropertyBagRegistry ( void );
    //! class destructor
    virtual ~dia_PropertyBagRegistry ( void );

    //! open the property bag
    virtual tDiaResult open ( void ) override;
    //! open the property bag
    virtual tDiaResult close ( void ) override;

    //! retrieve an n-byte stream property
    virtual tDiaResult getProperty ( tU32 /*propID*/, tU8 /*propValue*/[], size_t /*propLength*/ ) override { return DIA_E_NOT_IMPLEMENTED; }
    //! retrieve an n-byte stream property
    virtual tDiaResult getProperty ( tU32 propID, tU8 propValue[], size_t* propLength ) override;
    //! retrieve an n-byte stream property
    virtual tDiaResult getProperty ( tU32 propID, std::vector<tU8>& dataVec ) override;
    //! retrieve a 4 byte property
    virtual tDiaResult getPropertyU32 ( tU32 propID, tU32& propValue ) override;
    //! set property
    virtual tDiaResult setProperty ( tU32 propID, tU8 propValue[], size_t propLength ) override;

    tDiaResult loadRegKeys  ( const dia_RegKeyInfo  regKeyData[],  tU16 numOfKeys  );
    tDiaResult loadRegPaths ( const dia_RegPathInfo regPathData[], tU16 numOfPaths );

protected:
    //! this method is used to query
    const tChar* queryRegKey  ( tU32 propID );
    //! this method is used to query
    const tChar* queryRegPath ( tU32 propID );

protected:
    //! repository of registry keys
    std::map<tU32,const tChar*> mRegKeyRep;
    //! repository of registry paths
    std::map<tU32,const tChar*> mRegPathRep;
};

#endif
