/*
 * dia_PropertyBagRAM.h
 *
 *  Created on: 17.12.2010
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_PROPERTY_BAG_RAM__
#define __INCLUDED_DIA_PROPERTY_BAG_RAM__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_PROPERTY_BAG__
#include "dia_PropertyBag.h"
#endif

class dia_PropertyBagRAM
    : public dia_PropertyBag
{
public:
    //! this is the only class constructor subclasses can use
    dia_PropertyBagRAM ( void );
    //! class destructor
    virtual ~dia_PropertyBagRAM ( void );

    //
    // overloaded methods from dia_PropertyBag base class
    //

    //! open the property bag
    virtual tDiaResult open ( void ) override { return DIA_SUCCESS; }
    //! open the property bag
    virtual tDiaResult close ( void ) override { return DIA_SUCCESS; }

    //! retrieve a 1 byte property
    virtual tDiaResult getPropertyU8 ( tU32 propID, tU8&  propValue ) override;
    //! retrieve a 2 byte property
    virtual tDiaResult getPropertyU16 ( tU32 propID, tU16& propValue ) override;
    //! retrieve a 4 byte property
    virtual tDiaResult getPropertyU32 ( tU32 propID, tU32& propValue ) override;
    //! retrieve the data[] of the specified DID from RAM (fix length)
    virtual tDiaResult getProperty ( tU32 propID, tU8 propValue[], size_t propLength ) override;
    //! retrieve the data[] of the specified DID from RAM (returns property length)
    virtual tDiaResult getProperty ( tU32 propID, tU8 propValue[], size_t* propLength ) override;
    //! retrieve the data[] of the specified DID from RAM
    virtual tDiaResult getProperty ( tU32 propID, std::vector<tU8>& propValue ) override;

    //! set property
    virtual tDiaResult setPropertyU8 ( tU32 propID, tU8 propValue ) override;
    //! set property
    virtual tDiaResult setPropertyU16 ( tU32 propID, tU16 propValue ) override;
    //! set property
    virtual tDiaResult setPropertyU32 ( tU32 propID, tU32 propValue ) override;
    //! set property
    virtual tDiaResult setProperty  ( tU32 propID, tU8 propValue[], size_t propLength ) override;
};

#endif /* __INCLUDED_DIA_PROPERTY_BAG_RAM__ */
