/*
 * dia_PropertyBagKDSVarLen.h
 *
 *  Created on: 18.06.2016
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_PROPERTY_BAG_KDS_VARLEN__
#define __INCLUDED_DIA_PROPERTY_BAG_KDS_VARLEN__

#ifndef __INCLUDED_DIA_PROPERTY_BAG__
#include "common/framework/config/dia_PropertyBag.h"
#endif

#ifndef __INCLUDED_DIA_NATIVE_KDS_INTERFACE__
#include "common/framework/config/dia_IKDS.h"
#endif

class dia_IDriver;

namespace dia {

class PropertyBagKDSVarLen
    : public dia_PropertyBag //,
//      public dia_IKDS
{
//    friend class dia_UnitTestPropertyBagKDS;

public:
   PropertyBagKDSVarLen ( dia_PropertyBagKDS& propBagKDS );

    //! this is the only class constructor subclasses can use
   PropertyBagKDSVarLen ( void );
//    //! this is the only class constructor subclasses can use
//   PropertyBagKDSVarLen ( dia_IDriver* kdsDriver );
    //! class destructor
    virtual ~PropertyBagKDSVarLen ( void );

    //
    // overloaded methods from dia_PropertyBag base class
    //

    //! open the property bag
    virtual tDiaResult open ( void ) override;
    //! open the property bag
    virtual tDiaResult close ( void ) override;

    //! read a byte stream property of up to <maxPropLength> size in bytes from KDS. stream is returned as array. actual size of returned stream will be assigned to parameter <maxPropLength>
    virtual tDiaResult getProperty ( tU32 propID, tU8 propValue[], size_t* maxPropLength ) override;
    //! read a byte stream property from KDS. stream is returned as vector container. size of stream can be retrieved from vector
    virtual tDiaResult getProperty ( tU32 propID, std::vector<tU8>& propValue ) override;

    //! set property (assign an byte stream of <propLength> size in bytes) stored in KDS
    virtual tDiaResult setProperty ( tU32 propID, tU8 propValue[], size_t propLength ) override;
    //! set property (assign an byte stream using a vector container)
//    virtual tDiaResult setProperty ( tU32 propID, const std::vector<tU8>& propValue );

//    //! update internal lookup tables
//    virtual tDiaResult update ( void );

//    //! number of managed KDS keys
//    virtual tU16 getCardinality ( void ) const;

    //! force KDS flush
    virtual tDiaResult flush ( void ) override;

    //
    // implementations for methods defined in dia_tclConfigInterfaceKDS
    //

    /**
     * \brief      generic status mask handling for write commands (Status Test)
     *
     *             This function handles the status mask handling for writeKDS commands.
     *             StausMask handling takes place before the write access.
     *
     * \param[in]  key      DID of the KDS key. (e.g. 0x0047)
     * \param[in]  data     Pointer to the data structure. Changes will be done in it.
     * \param[in]  statMask Status mask of the message.
     * \param[in]  length   Length/Number of elements in the data field.
     *
     * \return     tDiaResult   DIA_SUCCESS or DIA_FAILED
     */
//    tDiaResult handleStatMask4Write(tU16 key, tU8* data, tU16 statMask, tU16 &length) const;

    /**
     * \brief      generic status mask handling for read commands (Status Test)
     *
     *             This function handles the status mask handling for readKDS commands.
     *             StausMask handling takes place after the read access.
     *
     * \param[in]  key      DID of the KDS key. (e.g. 0x0047)
     * \param[in]  data     Pointer to the data structure. Changes will be done in it.
     * \param[in]  statMask Status mask of the message.
     * \param[in]  length   Length/Number of elements in the data field.
     *
     * \return     tDiaResult   DIA_SUCCESS or DIA_FAILED
    */
//    tDiaResult handleStatMask4Read(tU32 propID, const tU8* data, tU16 statMask, tU16 &length) const;


    //
    // overloaded methods from dia_IKDS
    //

//    //! native read from KDS
//    virtual tDiaResult readKDS  ( tU16 key, tU8 data[], tU16 length );
//    //! native write to KDS
//    virtual tDiaResult writeKDS ( tU16 key, tU8 data[], tU16 length );
//    //! native flushing of KDS
//    virtual tDiaResult flushKDS ( void );
//    //! enable/disable KDS flushing
//    virtual tDiaResult setFlushMode ( enFlushMode mode );
//    //! register a listener for the given KDS key
//    virtual tDiaResult addKDSListener ( tU16 kdsKey, dia_IKDSListener* pListener );
//    //! unregister a listener for the given KDS key
//    virtual tDiaResult removeKDSListener ( tU16 kdsKey, dia_IKDSListener* pListener );

protected:
//    dia_IDriver* mpDriverKDS;
    dia_PropertyBagKDS* mpPropBagKDS;

//    std::map<tU16,dia_PropertyInfo*> mKeyRep;
//    std::map<tU16,dia_IKDSListener*> mKeyListenerRep;
};

}

#endif
