#ifndef __INCLUDED_DIA_PROPERTY_BAG_KDS__
#define __INCLUDED_DIA_PROPERTY_BAG_KDS__

#ifndef __INCLUDED_DIA_PROPERTY_BAG__
#include <common/framework/config/dia_PropertyBag.h>
#endif

#ifndef __INCLUDED_DIA_NATIVE_KDS_INTERFACE__
#include <common/framework/config/dia_IKDS.h>
#endif

#ifndef __INCLUDED_DIA_OSAL_DRIVER_KDS__
#include <common/framework/platform/osal/dia_OSALDriverKDS.h>
#endif

class dia_IDriver;

class dia_PropertyBagKDS
    : public dia_PropertyBag,
      public dia_IKDS
{
    friend class dia_UnitTestPropertyBagKDS;

public:
    //! this is the only class constructor subclasses can use
    dia_PropertyBagKDS ( void );
    //! this is the only class constructor subclasses can use
    dia_PropertyBagKDS ( dia_IDriver* kdsDriver );
    //! class destructor
    virtual ~dia_PropertyBagKDS ( void );

    //
    // overloaded methods from dia_PropertyBag base class
    //

    //! open the property bag
    virtual tDiaResult open ( void ) override;
    //! open the property bag
    virtual tDiaResult close ( void ) override;

    //! read a byte stream property of <propLength> size in bytes from KDS. stream is returned as array. length must match exactly
    virtual tDiaResult getProperty ( tU32 propID, tU8 propValue[], size_t propLength ) override;
    //! read a byte stream property of up to <maxPropLength> size in bytes from KDS. stream is returned as array. actual size of returned stream will be assigned to parameter <maxPropLength>
    virtual tDiaResult getProperty ( tU32 propID, tU8 propValue[], size_t* maxPropLength ) override;
    //! read a byte stream property from KDS. stream is returned as vector container. size of stream can be retrieved from vector
    virtual tDiaResult getProperty ( tU32 propID, std::vector<tU8>& propValue ) override;
    //! retrieve a 1 byte property stored in KDS
    virtual tDiaResult getPropertyU8(tU32 propID, tU8& propValue) override;
    //! retrieve a 2 byte property stored in KDS
    virtual tDiaResult getPropertyU16(tU32 propID, tU16& propValue) override;
    //! retrieve a 4 byte property stored in KDS
    virtual tDiaResult getPropertyU32(tU32 propID, tU32& propValue ) override;

    //! set property (assign an byte stream of <propLength> size in bytes) stored in KDS
    virtual tDiaResult setProperty ( tU32 propID, tU8 propValue[], size_t propLength ) override;
    //! set property (assign 4 byte value) stored in KDS
    virtual tDiaResult setPropertyU32 ( tU32 /*propID*/, tU32 /*propValue*/ ) override;

    //! update internal lookup tables
    virtual tDiaResult update ( void ) override;

    //! number of managed KDS keys
    virtual tU16 getCardinality ( void ) const override;

    //! force KDS flush
    virtual tDiaResult flush ( void ) override;

    //
    // implementations for methods defined in dia_tclConfigInterfaceKDS
    //

    /**
     * \brief      generic status mask handling for write commands (Status Test)
     *
     *             This function handles the status mask handling for writeKDS commands.
     *             StausMask handling takes place before the write access.
     *
     * \param[in]  key      DID of the KDS key. (e.g. 0x0047)
     * \param[in]  data     Pointer to the data structure. Changes will be done in it.
     * \param[in]  statMask Status mask of the message.
     * \param[in]  length   Length/Number of elements in the data field.
     *
     * \return     tDiaResult   DIA_SUCCESS or DIA_FAILED
     */
    tDiaResult handleStatMask4Write(tU16 key, tU8* data, tU16 statMask, size_t &length) const;

    /**
     * \brief      generic status mask handling for read commands (Status Test)
     *
     *             This function handles the status mask handling for readKDS commands.
     *             StausMask handling takes place after the read access.
     *
     * \param[in]  key      DID of the KDS key. (e.g. 0x0047)
     * \param[in]  data     Pointer to the data structure. Changes will be done in it.
     * \param[in]  statMask Status mask of the message.
     * \param[in]  length   Length/Number of elements in the data field.
     *
     * \return     tDiaResult   DIA_SUCCESS or DIA_FAILED
    */
    tDiaResult handleStatMask4Read(tU32 propID, const tU8* data, tU16 statMask, size_t &length) const;


    //
    // overloaded methods from dia_IKDS
    //

    //! native read from KDS
    virtual tDiaResult readKDS  ( tU16 key, tU8 data[], tU16 length );
    //! native write to KDS
    virtual tDiaResult writeKDS ( tU16 key, tU8 data[], tU16 length );
    //! native flushing of KDS
    virtual tDiaResult flushKDS ( void );
    //! enable/disable KDS flushing
    virtual tDiaResult setFlushMode ( enFlushMode mode );
    //! register a listener for the given KDS key
    virtual tDiaResult addKDSListener ( tU16 kdsKey, dia_IKDSListener* pListener );
    //! unregister a listener for the given KDS key
    virtual tDiaResult removeKDSListener ( tU16 kdsKey, dia_IKDSListener* pListener );

    tDiaResult writeKDS ( dia_OSALDriverKDS::sDataKDS& kdsData );
    tDiaResult readKDS ( dia_OSALDriverKDS::sDataKDS& kdsData );

    dia_IDriver* getDriverKDS ( void ) const { return mpDriverKDS; }

    void configureLengthCheck ( bool mode ) { mIsLengthCheckEnabled = mode; }

private:
    dia_IDriver* mpDriverKDS;
//    dia_OSALDriverKDS* mpDriverKDS;
    std::map<tU16,dia_PropertyInfo*> mKeyRep;
    std::map<tU16,dia_IKDSListener*> mKeyListenerRep;
    bool mIsLengthCheckEnabled;
};

#endif
