#ifndef __INCLUDED_DIA_PROPERTY_BAG_GPIO__
#define __INCLUDED_DIA_PROPERTY_BAG_GPIO__

#ifndef __INCLUDED_DIA_PROPERTY_BAG__
#include "common/framework/config/dia_PropertyBag.h"
#endif

class dia_PropertyBagGPIO
    : public dia_PropertyBag //,
//    public dia_IGPIO
{
public:
    //! this is the only class constructor subclasses can use
    dia_PropertyBagGPIO ( tVoid );
    //! class destructor
    virtual ~dia_PropertyBagGPIO ( tVoid );

    //
    // overloaded methods from dia_PropertyBag base class
    //

    //! open the property bag
    virtual tDiaResult open ( tVoid ) override;
    //! open the property bag
    virtual tDiaResult close ( tVoid ) override;

    //! return the size of the given property
    virtual size_t getSize ( tU32 propID ) override;

    //! read the data of the specified from GPIO
    virtual tDiaResult getProperty ( tU32 propID, tU8 propValue[], size_t* propLength ) override;
    virtual tDiaResult getProperty ( tU32, tU8 [], size_t ) override { return DIA_E_NOT_IMPLEMENTED; }
    //! read a byte stream property from KDS. stream is returned as vector container. size of stream can be retrieved from vector
    virtual tDiaResult getProperty ( tU32 propID, std::vector<tU8>& propValue ) override;

    //! set GPIO state
    virtual tDiaResult setProperty ( tU32 propID, tU8 propValue[], size_t propLength ) override;

    //! retrieve a 4 byte property stored in GPIO
    virtual tDiaResult getPropertyBool ( tU32 propID, tBool& propValue ) override;

    tDiaResult loadGPIOKeys  ( const dia_RegKeyInfo  GPIOKeyData[],  tU16 numOfKeys  );
    tDiaResult loadGPIOPaths ( const dia_RegPathInfo regPathData[], tU16 numOfPaths );
    //tU32 getPropertyKey ( const tChar* regKeyName, const tChar* regPathName );


protected:
    //! native read method
    virtual tDiaResult readGPIO ( tU32 pinID, tBool& pinStatus );
    // get the GPIO pin Number from the Boardconfig
    //tU32 getPropertyGPIOKey ( const tChar* regKeyName, const tChar* regPathName );
    //! this method is used to query
    const tChar* queryRegKey  ( tU32 propID );
    //! this method is used to query
    const tChar* queryRegPath ( tU32 propID );
    //! repository of registry keys
    std::map<tU32,const tChar*> mGPIOKeyRep;
    //! repository of registry paths
    std::map<tU32,const tChar*> mRegPathRep;
    //! this method set GPIO
    virtual tDiaResult writeGPIO ( tU32 pinID, tBool pinStatus );


private:
    //! device descriptor of the KDS driver
    OSAL_tIODescriptor mDrvHandle;
    //! flag to indicate whether the driver was opened or not
    bool mIsOpenGPIO;
};

#endif
