#define  SYSTEM_S_IMPORT_INTERFACE_COMPLETE
#include "system_pif.h"

#ifndef __INCLUDED_DIA_COMMON_CONFIG__
#include "common/framework/config/dia_common_config.h"
#endif

//----------------------------------------------------------------------------------------

dia_PropertyBagGPIO::dia_PropertyBagGPIO ( tVoid )
    : dia_PropertyBag(DIA_C_STR_PROPBAG_GPIO),
      mDrvHandle(OSAL_ERROR),
      mIsOpenGPIO(false)
{
    dia_tclFnctTrace trc("dia_PropertyBagGPIO::dia_PropertyBagGPIO");
}

//----------------------------------------------------------------------------------------

dia_PropertyBagGPIO::~dia_PropertyBagGPIO ( tVoid )
{
//    dia_tclFnctTrace trc("dia_PropertyBagGPIO::~dia_PropertyBagGPIO");
}

//----------------------------------------------------------------------------------------
tDiaResult
getPropertyGPIOKey(const tChar* regKeyName, const tChar* regPathName, tU32& u32GpioPinNumber )
{
   dia_tclFnctTrace trc("dia_PropertyBagGPIO::getPropertyGPIOKey");

   tDiaResult retCode = DIA_E_OPEN_FAILED_GPIO;

   intptr_t s32RetAddr = OSAL_IOOpen(regPathName, OSAL_EN_READONLY);

   /* open registry entry BOARDCFG for read only */
   if ( s32RetAddr != OSAL_ERROR )
   {
      /* if open is possible, then read out the gpio pin numbers which you want to use */
      OSAL_trIOCtrlRegistry rReg;
      tU32 u32GpioPinNumberVal = 0;

      /* e.g. gpio pin number for camera VCC on */
      rReg.pcos8Name = (tPCS8) regKeyName;
      rReg.ps8Value  = (tU8*)&u32GpioPinNumberVal;
      rReg.u32Size   = sizeof(tS32);
      rReg.s32Type = OSAL_C_S32_VALUE_S32;

      if ( (OSAL_s32IOControl(s32RetAddr, OSAL_C_S32_IOCTRL_REGGETVALUE, (intptr_t)&rReg)) != OSAL_ERROR )
      {
         u32GpioPinNumber = u32GpioPinNumberVal;
         retCode = DIA_SUCCESS;
      }
      else
      {
         DIA_TR_INF("Unable to get the GPIO Number !!");
      }

      OSAL_s32IOClose(s32RetAddr);//Coverity Fix(CID:139609)
   } //lint !e550: Symbol not accessed, but required to pass a valid parameter in function call
   else
   {
      DIA_TR_INF("Unable to Open Reg !!");
   }

   return retCode;
}


//----------------------------------------------------------------------------------------
tDiaResult
dia_PropertyBagGPIO::open ( tVoid )
{
    dia_tclFnctTrace trc("dia_PropertyBagGPIO::open");

    tDiaResult retCode = DIA_E_OPEN_FAILED_GPIO;

    mDrvHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_GPIO,OSAL_EN_READWRITE);
    if ( mDrvHandle != OSAL_ERROR )
    {
       mIsOpenGPIO = true;
        retCode     = DIA_SUCCESS;
    }

    if ( retCode != DIA_SUCCESS )
    {
       DIA_TR_INF("%s", const_cast<tChar*>(OSAL_coszErrorText(OSAL_u32ErrorCode())));
    }

    return retCode;
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBagGPIO::close ( tVoid )
{
    dia_tclFnctTrace trc("dia_PropertyBagGPIO::close");

    if ( mIsOpenGPIO )
    {
        OSAL_s32IOClose(mDrvHandle);
        mIsOpenGPIO = false;
    }

    return DIA_SUCCESS;
}

//----------------------------------------------------------------------------------------

size_t
dia_PropertyBagGPIO::getSize ( tU32 /*propID*/ )
{
    return sizeof(tU8);
}

//----------------------------------------------------------------------------------------

//! retrieve a 4 byte property stored in GPIO
tDiaResult
dia_PropertyBagGPIO::getPropertyBool ( tU32 propID, tBool& propValue )
{
    dia_tclFnctTrace trc("dia_PropertyBagGPIO::getPropertyBool()");
    return readGPIO(propID, propValue);
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBagGPIO::getProperty ( tU32 propID, tU8 propValue[], size_t* propLength )
{
    dia_tclFnctTrace trc("dia_PropertyBagGPIO::getPropert(bytestream)");
    tDiaResult retCode = DIA_FAILED;
    dia_PropertyInfo propData;
    tU32 u32GpioPinNumber = 0;

    if ( queryProperty(propID,propData) != DIA_SUCCESS )
    {
        return DIA_E_INVALID_KEY;
    }
    auto length  = propData.mPropSize;
    if ( (!length) || (*propLength < length) )
    {
        return DIA_E_INVALID_LENGTH;
    }

    if (propData.mPropExtData[0] == DIA_PROP_SRC_GPIO_KEY_UNKNOWN)
    {// direct pin access
       u32GpioPinNumber = static_cast<tU32>(propData.mPropExtData[1]);
    }
    else
    {// access of regestry entry
        const tChar* regKeyName  = queryRegKey(static_cast<tU32>(propData.mPropExtData[0]));
        const tChar* regPathName = queryRegPath(static_cast<tU32>(propData.mPropExtData[1]));
        if ( getPropertyGPIOKey ( regKeyName, regPathName, u32GpioPinNumber ) != DIA_SUCCESS )
        {
            return DIA_E_INVALID_KEY;
        }

        if ( queryProperty(propID,propData) != DIA_SUCCESS )
        {
            return DIA_E_INVALID_KEY;
        }

    }

    if (*propLength == 1)
    {
       tBool Value;
       retCode = readGPIO(u32GpioPinNumber, Value);
       if (retCode == DIA_SUCCESS )
       {
          propValue[0] = (tU8) Value;
          DIA_TR_INF("propValue:%d ",Value );
       }
    }
    else
    {
       DIA_TR_INF("only allow to read one pin State!!");
       retCode = DIA_FAILED;
    }
    return  retCode;

}

//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBagGPIO::getProperty ( tU32 propID, std::vector<tU8>& propValue )
{
    dia_tclFnctTrace trc("dia_PropertyBagGPIO::getPropert(tU32, std::vector<tU8>&)");
    tDiaResult retCode = DIA_FAILED;
    dia_PropertyInfo propData;
    tU32 u32GpioPinNumber = 0;

    if ( queryProperty(propID,propData) != DIA_SUCCESS )
    {
        return DIA_E_INVALID_KEY;
    }
    auto length  = propData.mPropSize;
    propValue.resize(length);

    if ( (!length) )
    {
        return DIA_E_INVALID_LENGTH;
    }

    if (propData.mPropExtData[0] == DIA_PROP_SRC_GPIO_KEY_UNKNOWN)
    {// direct pin access
       u32GpioPinNumber = static_cast<tU32>(propData.mPropExtData[1]);
    }
    else
    {// access of regestry entry
        const tChar* regKeyName  = queryRegKey(static_cast<tU32>(propData.mPropExtData[0]));
        const tChar* regPathName = queryRegPath(static_cast<tU32>(propData.mPropExtData[1]));
        if ( getPropertyGPIOKey ( regKeyName, regPathName, u32GpioPinNumber ) != DIA_SUCCESS )
        {
            return DIA_E_INVALID_KEY;
        }

        if ( queryProperty(propID,propData) != DIA_SUCCESS )
        {
            return DIA_E_INVALID_KEY;
        }

    }

    if (length == 1)
    {
       tBool Value;
       retCode = readGPIO(u32GpioPinNumber, Value);
       if (retCode == DIA_SUCCESS )
       {
          propValue[0] = (tU8) Value;
          DIA_TR_INF("propValue:%d ",Value );
       }
    }
    else
    {
       DIA_TR_INF("only allow to read one pin State!!");
       retCode = DIA_FAILED;
    }
    return  retCode;

}
//----------------------------------------------------------------------------------------
tDiaResult
dia_PropertyBagGPIO::readGPIO ( tU32 pinID, tBool& pinStatus )
{
    dia_tclFnctTrace trc("dia_PropertyBagGPIO::readGPIO(bool)");

    tDiaResult retCode = DIA_E_READ_FAILED_GPIO;

    if ( open() == DIA_SUCCESS )
    {

        OSAL_trGPIOData     tGpioData;

        // Update the dev id
        tGpioData.tId = (OSAL_tGPIODevID) pinID;

        if ( OSAL_ERROR == OSAL_s32IOControl ( mDrvHandle, OSAL_C_32_IOCTRL_GPIO_IS_STATE_ACTIVE,(intptr_t)(&tGpioData)) )
        {
           DIA_TR_INF("Unable to get GPIO state!!");
           retCode = DIA_E_READ_FAILED_GPIO;
        }
        else
        {

           pinStatus = tGpioData.unData.bState;
        DIA_TR_INF("GPIO PinStatus(Pin_%d) = %d",tGpioData.tId,pinStatus);
           retCode = DIA_SUCCESS;
        }
        close();
    }
    else
    {
       DIA_TR_INF("Unable to Open GPIO !!");
        retCode = DIA_E_OPEN_FAILED_GPIO;
    }

    return retCode;
}
//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBagGPIO::loadGPIOKeys ( const dia_RegKeyInfo GPIOKeyData[], tU16 numOfKeys )
{
    dia_tclFnctTrace oTrace("dia_PropertyBagGPIO::loadGPIOKeys");

    tDiaResult retCode = DIA_FAILED;

    if ( GPIOKeyData )
    {
        for ( tU16 i=0; i<numOfKeys; ++i )
        {
            mGPIOKeyRep[GPIOKeyData[i].mRegKeyID] = GPIOKeyData[i].mRegKeyValue;
        }
        retCode = DIA_SUCCESS;
    }

    return retCode;
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBagGPIO::loadGPIOPaths ( const dia_RegPathInfo regPathData[], tU16 numOfPaths )
{
    dia_tclFnctTrace oTrace("dia_PropertyBagGPIO::loadGPIOPaths");

    tDiaResult retCode = DIA_FAILED;

    if ( regPathData )
    {
        for ( tU16 i=0; i<numOfPaths; ++i )
        {
            mRegPathRep[regPathData[i].mRegPathID] = regPathData[i].mRegPathValue;
        }
        retCode = DIA_SUCCESS;
    }

    return retCode;
}

//----------------------------------------------------------------------------------------

const tChar*
dia_PropertyBagGPIO::queryRegKey  ( tU32 propID )
{
   const tChar* keyName = NULL;

   std::map<tU32,const tChar*>::iterator iter = mGPIOKeyRep.find(propID);

   if ( iter != mGPIOKeyRep.end() )
   {
      keyName = mGPIOKeyRep[propID];
   }
   else
   {
      DIA_TR_ERR("--- QueryGPIOKey failed (key=0x%x) ---",propID );
   }

   return keyName;
}

//----------------------------------------------------------------------------------------

const tChar*
dia_PropertyBagGPIO::queryRegPath ( tU32 propID )
{
   const tChar* pathName = NULL;

   std::map<tU32,const tChar*>::iterator iter = mRegPathRep.find(propID);

   if ( iter != mRegPathRep.end() )
   {
      pathName = mRegPathRep[propID];
   }
   else
   {
      DIA_TR_ERR("--- queryRegPath failed (key=0x%x) ---",propID );
   }

   return pathName;
}
//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBagGPIO::setProperty ( tU32 propID, tU8 propValue[], size_t propLength )
{
    dia_tclFnctTrace trc("dia_PropertyBagGPIO::setProperty(bytestream)");
    tDiaResult retCode = DIA_FAILED;
    dia_PropertyInfo propData;
    tU32 u32GpioPinNumber = 0;

    if ( queryProperty(propID,propData) != DIA_SUCCESS )
    {
        return DIA_E_INVALID_KEY;
    }

    auto length  = propData.mPropSize;

    if ( (!length) || (propLength < length) )
    {
        return DIA_E_INVALID_LENGTH;
    }

    if (propData.mPropExtData[0] == DIA_PROP_SRC_GPIO_KEY_UNKNOWN)
    {// direct pin access
       u32GpioPinNumber = static_cast<tU32>(propData.mPropExtData[1]);
    }
    else
    {// access of regestry entry
        const tChar* regKeyName  = queryRegKey(static_cast<tU32>(propData.mPropExtData[0]));
        const tChar* regPathName = queryRegPath(static_cast<tU32>(propData.mPropExtData[1]));
        if ( getPropertyGPIOKey ( regKeyName, regPathName, u32GpioPinNumber ) != DIA_SUCCESS )
        {
            return DIA_E_INVALID_KEY;
        }

        if ( queryProperty(propID,propData) != DIA_SUCCESS )
        {
            return DIA_E_INVALID_KEY;
        }
    }

    if (propLength == 1)
    {
       retCode = writeGPIO(u32GpioPinNumber, (tBool)propValue[0]);
       if (retCode == DIA_SUCCESS )
       {
          DIA_TR_INF("propValue:%d ",propValue[0] );
       }
    }
    else
    {
       DIA_TR_INF("only allow to read one pin State!!");
       retCode = DIA_FAILED;
    }
    return  retCode;

}
//----------------------------------------------------------------------------------------
tDiaResult
dia_PropertyBagGPIO::writeGPIO ( tU32 pinID, tBool pinStatus )
{
   dia_tclFnctTrace trc("dia_PropertyBagGPIO::writeGPIO(tU32,tBool)");

   tDiaResult retCode = DIA_E_READ_FAILED_GPIO;

   if ( open() == DIA_SUCCESS )
   {
      OSAL_trGPIOData     tGpioData;

      // Update the dev id
      tGpioData.tId = (OSAL_tGPIODevID) pinID;
      tGpioData.unData.bState = pinStatus;

      int tGpioStatus = (pinStatus == false) ? OSAL_C_32_IOCTRL_GPIO_SET_INACTIVE_STATE: OSAL_C_32_IOCTRL_GPIO_SET_ACTIVE_STATE;

      DIA_TR_INF("dia_PropertyBagGPIO::writeGPIO - GPIO_0 (Pin_%d) = %d",tGpioData.tId,tGpioData.unData.bState);

      if ( OSAL_ERROR == OSAL_s32IOControl ( mDrvHandle, tGpioStatus,(intptr_t)(&tGpioData)) )
      {
         DIA_TR_INF("dia_PropertyBagGPIO::writeGPIO - Unable to set GPIO state!!");
         DIA_TR_INF("dia_PropertyBagGPIO::writeGPIO - GPIO (Pin_%d) = %d",tGpioData.tId,tGpioData.unData.bState);
         retCode = DIA_E_READ_FAILED_GPIO;
      }
      else
      {
         DIA_TR_INF("dia_PropertyBagGPIO::writeGPIO - GPIO Pin set to Status(Pin_%d) = %d",tGpioData.tId,pinStatus);
         retCode = DIA_SUCCESS;
      }
      close();
   }
   else
   {
      DIA_TR_INF("dia_PropertyBagGPIO::writeGPIO - Unable to Open GPIO !!");
      retCode = DIA_E_OPEN_FAILED_GPIO;
   }

   return retCode;
}
//----------------------------------------------------------------------------------------
