/*
 * dia_PropertyBagFileSwitches.cpp
 *
 *  Created on: 13.11.2015
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_PROPERTY_BAG_FILE_SWITCHES__
#include <common/framework/config/dia_PropertyBagFileSwitches.h>
#endif

#ifndef __INCLUDED_DIA_FILE_DIR__
#include <common/framework/application/dia_FileDir.h>
#endif

#ifndef __INCLUDED_DIA_FILE__
#include <common/framework/application/dia_File.h>
#endif

#define DIA_C_U32_PROPERTY_FILESWITCH_TYPE_FILE    ((tU32) 0x00000001)
#define DIA_C_U32_PROPERTY_FILESWITCH_TYPE_DIR     ((tU32) 0x00000002)

//----------------------------------------------------------------------------------------

dia_PropertyBagFileSwitches::dia_PropertyBagFileSwitches ( void )
    : dia_PropertyBag(DIA_C_STR_PROPBAG_FILESWITCH)
{
    dia_tclFnctTrace trc("dia_PropertyBagFileSwitches::dia_PropertyBagFileSwitches");
}

//----------------------------------------------------------------------------------------

dia_PropertyBagFileSwitches::~dia_PropertyBagFileSwitches ( void )
{}

//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBagFileSwitches::getPropertyBoolean ( tU32 propID, bool& propValue )
{
    dia_tclFnctTrace trc("dia_PropertyBagFileSwitches::getPropertyBoolean()");

    tDiaResult retCode = DIA_FAILED;

    dia_PropertyInfo propData;

    // initialize the boolean parameter
    propValue = false;

    if ( queryProperty(propID,propData) != DIA_SUCCESS )
    {
        return DIA_E_INVALID_KEY;
    }

    if ( propData.mPropSize != sizeof(bool) )
    {
        return DIA_E_INVALID_LENGTH;
    }

    tU32     bitmask       = (tU32)propData.mPropExtData[0];
    tCString filePathName  = (tCString) propData.mPropExtData[1];

    if ( (bitmask & DIA_C_U32_PROPERTY_FILESWITCH_TYPE_FILE) && (bitmask & DIA_C_U32_PROPERTY_FILESWITCH_TYPE_DIR) )
    {
       DIA_TR_ERR("dia_PropertyBagFileSwitches: INVALID BITMASK CONFIGURATION DETECTED.");
       return DIA_FAILED;
    }

    if ( bitmask & DIA_C_U32_PROPERTY_FILESWITCH_TYPE_FILE )
    {
       dia_File file(filePathName);
       propValue = file.doesExist();
       retCode = DIA_SUCCESS;
    }
    else if ( bitmask & DIA_C_U32_PROPERTY_FILESWITCH_TYPE_DIR )
    {
       dia_FileDir dirFile(filePathName);
       propValue = dirFile.doesExist();
       retCode = DIA_SUCCESS;
    }
    else
    {
       DIA_TR_ERR("dia_PropertyBagFileSwitches: NO BITMASK CONFIGURATION AVAILABLE.");
       return DIA_FAILED;
    }

    return retCode;
}
