/*!
 * \file       dia_PropertyBagFile.h
 *
 * \brief      {enter brief description here}
 *
 * \details    {enter detailed description here}
 *
 * \component  {enter component name}
 *
 * \ingroup    {enter group name}
 *
 * \copyright  (c) 2015 Robert Bosch Car Multimedia GmbH
 *
 */

#ifndef __INCLUDED_DIA_PROPERTY_BAG_FILE__
#define __INCLUDED_DIA_PROPERTY_BAG_FILE__

#ifndef __INCLUDED_DIA_PROPERTY_BAG__
#include <common/framework/config/dia_PropertyBag.h>
#endif

class dia_PropertyBagFile
   : public dia_PropertyBag
{
public:
    //! this is the only class constructor subclasses can use
   dia_PropertyBagFile ( void );
   //! class destructor
   virtual ~dia_PropertyBagFile ( void );

    //
    // overloaded methods from dia_PropertyBag base class
    //

   //! open the property bag
   virtual tDiaResult open ( void ) override { return DIA_SUCCESS; }
   //! open the property bag
   virtual tDiaResult close ( void ) override { return DIA_SUCCESS; }

    //! return the maximum size of bytes that can be handled by the given property
    //virtual tU16 getSize ( tU32 propID );

    //! retrieve a a byte stream property. stream is returned as vector container. size of stream can be retrieved from vector
    virtual tDiaResult getProperty ( tU32 propID, std::vector<tU8>& /*propValue*/ ) override;
    //! set property (assign an byte stream using a vector container)
    virtual tDiaResult setProperty ( tU32 propID, const std::vector<tU8>& /*propValue*/ ) override;
    //! set property (assign an byte stream using a array)
    virtual tDiaResult setProperty ( tU32 propID, tU8 propValue[], size_t propLength ) override;
    //! set property (assign an byte stream using a array)
    virtual tDiaResult getProperty ( tU32 propID, tU8 propValue[], size_t* propLength ) override;
};

#endif /* __INCLUDED_DIA_PROPERTY_BAG_FILE__ */
