/*!
 * \file       dia_PropertyBagEngineClient.h
 *
 * \brief      This file is used to define common properties to communicate with external ECU (e.g. BCM)
 *
 * \details    Get and set methods are not thread safety functions because of callback usage.
 *             The instance of the class must be used by one thread.
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreConfig
 *
 * \copyright  (c) 2012-2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

/*
 *  Created on: 04.04.2017
 *      Author: kaa1hi
 */

#ifndef __INCLUDED_DIA_PROPERTY_ENGINE_CLIENT__
#define __INCLUDED_DIA_PROPERTY_ENGINE_CLIENT__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_PROPERTY_BAG__
#include "dia_PropertyBag.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_CLIENT_INTERFACE__
#include "common/framework/config/dia_IEngineClient.h"
#endif


class dia_PropertyBagEngineClient
    : public dia_PropertyBag
{
public:
    //! this is the only class constructor subclasses can use
    dia_PropertyBagEngineClient ();
    //! class destructor
    virtual ~dia_PropertyBagEngineClient ( void );

    //-------------------------------------------------------------------------
    //
    // overloaded methods from dia_PropertyBag base class
    //
    //-------------------------------------------------------------------------

    //! open the property bag
    virtual tDiaResult open ( void ) override { return DIA_SUCCESS; }
    //! open the property bag
    virtual tDiaResult close ( void ) override { return DIA_SUCCESS; }

    //! retrieve a a byte stream property. stream is returned as vector container. size of stream can be retrieved from vector
    virtual tDiaResult getProperty ( tU32 propID, std::vector<tU8>& /*propValue*/ ) override;

    //! retrieve a property asynchronously
    virtual tDiaResult getProperty ( tU32 propID, dia_IEngineClient* callback) override;

    //! set property (assign an byte stream of <propLength> size in bytes) stored in KDS
    virtual tDiaResult setProperty ( tU32 propID, tU8 propValue[], size_t propLength ) override;

    //! set property (assign 1 byte value) asynchronously
    virtual tDiaResult setPropertyU8 ( tU32 propID, tU8 propValue, dia_IEngineClient* callback) override;

private:
    //! map of callbacks (PropID,Callback)
    std::map<tU32,dia_IEngineClient*> mKeyCallbackRep;

    //! add callback to internal repository for specific property
    tDiaResult addCallback ( tU32 propID, dia_IEngineClient* pCallback );

    //! remove callback from repository for specific property
    tDiaResult removeCallback ( tU32 propID, dia_IEngineClient* pCallback );
};

#endif /* __INCLUDED_DIA_PROPERTY_ENGINE_CLIENT__ */
