/*
 * dia_PropertyBagDatapool.h
 *
 *  Created on: 14.01.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_PROPERTY_BAG_DATAPOOL__
#define __INCLUDED_DIA_PROPERTY_BAG_DATAPOOL__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_PROPERTY_BAG__
#include "dia_PropertyBag.h"
#endif

class dia_PropertyBagDatapool
    : public dia_PropertyBag
{
public:
    //! this is the only class constructor subclasses can use
   dia_PropertyBagDatapool ( void );
    //! class destructor
    virtual ~dia_PropertyBagDatapool ( void );

    //
    // overloaded methods from dia_PropertyBag base class
    //

    //! open the property bag
    virtual tDiaResult open ( void ) override { return DIA_SUCCESS; }
    //! open the property bag
    virtual tDiaResult close ( void ) override { return DIA_SUCCESS; }

    virtual tDiaResult flush ( void ) override;

    //! retrieve the data[] of the specified DID from RAM (fix length)
    virtual tDiaResult getProperty ( tU32 propID, tU8 propValue[], size_t propLength ) override;
    //! retrieve the data[] of the specified DID from RAM (returns property length)
    virtual tDiaResult getProperty ( tU32 propID, tU8 propValue[], size_t* propLength ) override;
    //! retrieve a a byte stream property. stream is returned as vector container. size of stream can be retrieved from vector
    virtual tDiaResult getProperty ( tU32 propID, std::vector<tU8>& propValue ) override;

    //! set property
    virtual tDiaResult setPropertyU8 ( tU32 propID, tU8 propValue ) override;
    //! set property
    virtual tDiaResult setProperty ( tU32 propID, tU8 propValue[], size_t propLength ) override;
    //! set property (assign an byte stream using a vector container)
    virtual tDiaResult setProperty ( tU32 propID, const std::vector<tU8>& propValue ) override;

protected:
    virtual tDiaResult flushProperty ( dia_PropertyInfo& propInfo );
};

#endif /* __INCLUDED_DIA_PROPERTY_BAG_DATAPOOL__ */
