#define  SYSTEM_S_IMPORT_INTERFACE_COMPLETE
#include "system_pif.h"

#ifndef __INCLUDED_DIA_COMMON_CONFIG__
#include "common/framework/config/dia_common_config.h"
#endif

//----------------------------------------------------------------------------------------

dia_PropertyBagADC::dia_PropertyBagADC ( void )
    : dia_PropertyBag(DIA_C_STR_PROPBAG_ADC),
      mDrvHandle(OSAL_ERROR),
      mIsOpenADC(false),
      mADCID(DIA_PROP_SRC_ADC_DEVICE_UNKNOWN),
      mADCRes(0),
      mADCMask(0)
{
    dia_tclFnctTrace trc("dia_PropertyBagADC::dia_PropertyBagADC");
}

//----------------------------------------------------------------------------------------

dia_PropertyBagADC::~dia_PropertyBagADC ( void )
{
//    dia_tclFnctTrace trc("dia_PropertyBagADC::~dia_PropertyBagADC");
}


//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBagADC::open ( void )
{
   dia_tclFnctTrace trc("dia_PropertyBagADC::open");

   tDiaResult retCode = DIA_E_OPEN_FAILED_ADC;

   mDrvHandle = OSAL_IOOpen(aCommonRegADCPathData[mADCID].mRegADCPathValue, OSAL_EN_READWRITE);
   if ( mDrvHandle != OSAL_ERROR )
   {
      mIsOpenADC = true;
      retCode = DIA_SUCCESS;
   }

   if ( retCode != DIA_SUCCESS )
   {
      DIA_TR_INF("%s", const_cast<tChar*>(OSAL_coszErrorText(OSAL_u32ErrorCode())));
   }

   return retCode;
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBagADC::close ( void )
{
    dia_tclFnctTrace trc("dia_PropertyBagADC::close");

    tDiaResult retCode = DIA_E_OPEN_FAILED_ADC;

    if ( mIsOpenADC )
    {
        OSAL_s32IOClose(mDrvHandle);
        mIsOpenADC = false;
        retCode = DIA_SUCCESS;
    }

    return retCode;
}

//----------------------------------------------------------------------------------------

size_t
dia_PropertyBagADC::getSize ( tU32 /*propID*/ )
{
   return sizeof(tU16);
}
//----------------------------------------------------------------------------------------

bool
dia_PropertyBagADC::bIsOpen ( void )
{
   return mIsOpenADC;
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBagADC::getPropertyU32 ( tU32 propID, tU32& propValue )
{
   dia_tclFnctTrace trc("dia_PropertyBagADC::getPropert(tU32)");

   dia_PropertyInfo propData;

   if ( queryProperty(propID,propData) != DIA_SUCCESS )
   {
      return DIA_E_INVALID_KEY;
   }

   if ( !propData.mPropSize  )
   {
      return DIA_E_INVALID_LENGTH;
   }

   mADCID = (dia_enPropADCDevice) propData.mPropExtData[0];
   mADCRes = (dia_enPropADCDevice) propData.mPropExtData[1]; //resolution
   mADCMask = (dia_enPropADCDevice) propData.mPropExtData[2]; // mask

   /* Temperory code for backward compatibity.. To be removed */
   if((!mADCRes) && (!mADCMask))
   {
     DIA_TR_INF("-- NOTE: Bit mask and ADC resolution is not set, so taking default value");
      mADCMask = 0x00000FFF;

   }

   tU32 uValue = 0;
   tDiaResult retCode = readADCValue(uValue, mADCRes);
   if ( retCode == DIA_SUCCESS )
   {
      propValue = (uValue & mADCMask);
      DIA_TR_INF("propValue:%d ",propValue );
   }

   return retCode;
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBagADC::getPropertyU16 ( tU32 propID, tU16& propValue )
{
   dia_tclFnctTrace trc("dia_PropertyBagADC::getPropert(tU16)");

   dia_PropertyInfo propData;

   if ( queryProperty(propID,propData) != DIA_SUCCESS )
   {
      return DIA_E_INVALID_KEY;
   }

   if ( !propData.mPropSize  )
   {
      return DIA_E_INVALID_LENGTH;
   }

   mADCID = (dia_enPropADCDevice) propData.mPropExtData[0];
   mADCRes = (dia_enPropADCDevice) propData.mPropExtData[1]; //resolution
   mADCMask = (dia_enPropADCDevice) propData.mPropExtData[2]; // mask

   /* Temperory code for backward compatibity.. To be removed */
   if((!mADCRes) && (!mADCMask))
   {
     DIA_TR_INF("-- NOTE: Bit mask and ADC resolution is not set, so taking default value");
      mADCMask = 0x00000FFF;
   }

   tU32 uValue = 0;
   tDiaResult retCode = readADCValue(uValue, mADCRes);
   if ( retCode == DIA_SUCCESS )
   {
      propValue = (tU16) (uValue & mADCMask);
      DIA_TR_INF("propValue:%d ",propValue );
   }

   return retCode;
}


//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBagADC::readADCValue ( tU32& ADCValue, tU32 resolution )
{
   dia_tclFnctTrace trc("dia_PropertyBagADC::readADCValue ( tU32& ADCValue, tU32 resolution )");

   tDiaResult retCode = DIA_E_READ_FAILED_ADC;

/*
   const tU32 numOfBlocks = 1;
   const tU32 expectedBlockSize = sizeof(tU16);*/

   /* Temperory code for backward compatibity.. To be removed */
   if(!resolution)
   {
     resolution = 10; //sizeof(tU16);
    DIA_TR_INF("dia_PropertyBagADC::readADCValue modified resolution: %d", resolution);
   }

   if ( open() == DIA_SUCCESS )
   {
      // retrieve the size of bytes for the ADC value from driver
      tU32 adcResolution = 1;
      if (OSAL_ERROR == OSAL_s32IOControl(mDrvHandle, OSAL_C_S32_IOCTRL_ADC_GET_CONFIG, (intptr_t) &adcResolution))
      {
         DIA_TR_INF("UNABLE TO RETRIEVE BLOCK SIZE FROM ADC DRIVER !!");
      }
      else
      {
         DIA_TR_INF("Size of ADC value in bits: %d", adcResolution);

         //if ( adcBlockSize == (expectedBlockSize * numOfBlocks) ) //lint !e774: Boolean within 'if' always evaluates to False. Not true, as adcBlockSize gets assigned in the driver
       if ( adcResolution <= resolution )
         {
            // we only read data if the size matches
            tU8* pADCData = OSAL_NEW tU8[adcResolution];
            if ( pADCData != NULL )
            {
               if ( OSAL_ERROR == OSAL_s32IORead(mDrvHandle, (tPS8) pADCData, adcResolution) )
               {
                  DIA_TR_INF("UNABLE TO READ ADC VALUE !!");
               }
               else
               {
                  tU32* pADCValue = (tU32*) pADCData; //lint !e826 Info: Suspicious pointer-to-pointer conversion (area too small), but we are reerving more space than expected i,e 32bytes.
                  ADCValue = *pADCValue;
                  DIA_TR_INF("ADC  :: Data=%u!", (ADCValue));
                  retCode = DIA_SUCCESS;
               }
            }

            OSAL_DELETE [] pADCData;
         }
         else
         {
            DIA_TR_INF("UNABLE TO READ ADC VALUE (SIZE MISMATCH) !!");
         }
      }

      close();
   }

   return retCode;
}
