#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include "common/framework/config/dia_defsConfig.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_PROPERTY_BAG__
#include "common/framework/config/dia_PropertyBag.h"
#endif


//----------------------------------------------------------------------------------------

dia_PropertyBag::dia_PropertyBag ( tCString name )
   : dia_ObjectWithUID(name),
     mIsOpen(false)
{
}

//----------------------------------------------------------------------------------------

dia_PropertyBag::~dia_PropertyBag ( void )
{
}

//----------------------------------------------------------------------------------------

bool
dia_PropertyBag::bIsOpen ( void )
{
    return mIsOpen;
}

//----------------------------------------------------------------------------------------

size_t
dia_PropertyBag::getSize ( tU32 propID )
{
    size_t length = 0;

    dia_PropertyInfo propData;
    if ( queryProperty(propID,propData) == DIA_SUCCESS )
    {
        length = propData.mPropSize;
    }

    return length;
}
//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBag::queryProperty ( tU32 propID, dia_PropertyInfo& propData ) const
{
   tDiaResult retCode = DIA_FAILED;

   dia_ConfigManager* pCfgMgr = getInstanceOfConfigManager();

   if ( pCfgMgr )
   {
      DIA_DBG_TR_INF("dia_PropertyBag::queryProperty propID=0x%08X size()=%d", propID, pCfgMgr->mPropertyRepository.size());

      std::map<tU32,dia_PropertyInfo>::iterator iter = pCfgMgr->mPropertyRepository.find(propID);
      if ( iter != pCfgMgr->mPropertyRepository.end() )
      {
         propData = pCfgMgr->mPropertyRepository[propID];
         retCode  = DIA_SUCCESS;
      }
   }

   return retCode;
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBag::queryProperties ( dia_UID location, std::list<dia_PropertyInfo*>& props ) const
{
   tDiaResult retCode = DIA_FAILED;

   dia_ConfigManager* pCfgMgr = getInstanceOfConfigManager();

   if ( pCfgMgr )
   {
      std::map<tU32,dia_PropertyInfo>::iterator iter = pCfgMgr->mPropertyRepository.begin();
      for ( ; iter != pCfgMgr->mPropertyRepository.end(); ++iter )
      {
         if ( iter->second.mPropLoc == location )
         {
            props.push_back(&(iter->second));
         }
      }
      retCode  = DIA_SUCCESS;
   }

   return retCode;
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBag::updateProperty ( /*tU32 propID,*/ const dia_PropertyInfo& propData ) const
{
   tDiaResult retCode = DIA_FAILED;

   dia_ConfigManager* pCfgMgr = getInstanceOfConfigManager();

   if ( pCfgMgr && (pCfgMgr->loadProperty(/*propID,*/ propData) == DIA_SUCCESS) )
   {
      retCode  = DIA_SUCCESS;
   }

   return retCode;
}

//----------------------------------------------------------------------------------------

void
dia_PropertyBag::markDirty ( dia_PROPID propID )
{
   dia_tclFnctTrace trc("dia_PropertyBag::markDirty(dia_PROPID)");

   std::list<dia_PROPID>::iterator iter = std::find(mDirtyList.begin(), mDirtyList.end(), propID);
   if ( iter == mDirtyList.end() ) mDirtyList.push_back(propID);
}

//----------------------------------------------------------------------------------------

bool
dia_PropertyBag::isDirty ( dia_PROPID propID ) const
{
   dia_tclFnctTrace trc("dia_PropertyBag::isDirty(dia_PROPID)");

   std::list<dia_PROPID>::const_iterator iter = std::find(mDirtyList.begin(), mDirtyList.end(), propID);
   return ( iter != mDirtyList.end() ) ? true : false;
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBag::flush ( void )
{
   dia_tclFnctTrace trc("dia_PropertyBag::flush()");

   size_t numItems = mDirtyList.size();

   mDirtyList.clear();

   DIA_TR_INF("dia_PropertyBag::flush() %zu items has been deleted on dirty list.", numItems);

   return DIA_SUCCESS;
}
