/**
 * \file      dia_Property.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      08.05.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_PROPERTY__
#define __INCLUDED_DIA_PROPERTY__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include "common/framework/config/dia_defsConfig.h"
#endif

struct dia_PropertyInfo;

class dia_Property
{
public:
   //! default constructor
   dia_Property ( void );
   //! constructor
   dia_Property ( tU32 propID, dia_PropertyInfo* pInfo = 0 );
   //! copy constructor
   dia_Property ( const dia_Property& prop );
   //! assignment operator
   dia_Property& operator = ( const dia_Property& prop );
   //! destructor
   virtual ~dia_Property ( void );

   //! return the properties identifier
   tU32 getID ( void ) const;
   //! return the type of the property, e.g. boolean, tU8, tU16, tU32, string, ...
   dia_enPropType getType ( void ) const;
   //! return the size of the property
   size_t getSize ( void ) const;
   //! return the UID of the location where the property data is stored, e.g. KDS, registry, GPIO, ADC, ...
   dia_UID getLocation ( void ) const;

   //! set the link to the corresponding data structure
   tDiaResult load ( void );

protected:
   //! property identifier
   tU32 mPropID;
   //! property data item
   dia_PropertyInfo* mpPropInfo;
};

#endif /* DIA_PROPERTY_H_ */
