/**
 * \file      dia_Property.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      08.05.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#include "dia_Property.h"
#include "dia_ConfigManager.h"

//-----------------------------------------------------------------------------

dia_Property::dia_Property ( void )
   : mPropID(DIA_PROP_INVALID_IDENTIFIER),
     mpPropInfo(0)
{}

//-----------------------------------------------------------------------------

dia_Property::dia_Property ( tU32 propID, dia_PropertyInfo* pInfo )
   : mPropID(propID),
     mpPropInfo(pInfo)
{}

//-----------------------------------------------------------------------------

dia_Property::dia_Property ( const dia_Property& prop )
   : mPropID(prop.mPropID),
     mpPropInfo(prop.mpPropInfo) //lint !e1554: Direct pointer copy of member within copy constructor; pointer is quasi static
{}

//-----------------------------------------------------------------------------

dia_Property&
dia_Property::operator = ( const dia_Property& prop )
{
   if ( this != &prop )
   {
      mPropID = prop.mPropID;
      mpPropInfo = prop.mpPropInfo; //lint !e1555: Direct pointer copy of member within copy assignment operator; pointer is quasi static
   }
   return *this;
}

//-----------------------------------------------------------------------------

dia_Property::~dia_Property ( void )
{
   mpPropInfo = 0;
}

//-----------------------------------------------------------------------------

tU32
dia_Property::getID ( void ) const
{
   return mPropID;
}

//-----------------------------------------------------------------------------

dia_enPropType
dia_Property::getType ( void ) const
{
   return ( mpPropInfo ) ? mpPropInfo->mPropType : DIA_PROP_TYPE_UNKNOWN;
}

//-----------------------------------------------------------------------------

size_t
dia_Property::getSize ( void ) const
{
   return ( mpPropInfo ) ? mpPropInfo->mPropSize : 0;
}

//-----------------------------------------------------------------------------

dia_UID
dia_Property::getLocation ( void ) const
{
   return ( mpPropInfo ) ? mpPropInfo->mPropLoc : DIA_C_UID_PROPBAG_UNKNOWN;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_Property::load ( void )
{
   mpPropInfo = getInstanceOfConfigManager()->getPropertyInfo(mPropID);
   return ( mpPropInfo ) ? DIA_SUCCESS : DIA_FAILED;
}

