/*!
 * \file       dia_IEngineClient.h
 *
 * \brief      Interface for external access to the external ECU by CSM
 *
 * \details    Interface for external access to the external ECU by CSM
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreConfig
 *
 * \copyright  (c) 2012-2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_ENGINE_CLIENT_INTERFACE__
#define __INCLUDED_DIA_ENGINE_CLIENT_INTERFACE__

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include "dia_defsConfig.h"
#endif

class dia_IEngineClient
{
   DIA_DECL_CONFIGMANAGER_IID(DIA_C_IID_CONFMGR_ENGINE_CLIENT)

public:
   virtual tDiaResult getCallback ( tU32 propID, tDiaResult getStatus, tU8* buff, tU32 buffLen ) = 0;

   virtual tDiaResult setCallbackU8 ( tU32 propID, tDiaResult setStatus ) = 0;

   virtual tDiaResult setCallback ( tU32 propID, tDiaResult setStatus, tU8* buff, tU32 buffLen ) = 0;
protected:
    //! virtual class destructor
    virtual ~dia_IEngineClient ( void ) {}
};

#endif /* __INCLUDED_DIA_ENGINE_CLIENT_INTERFACE__ */
