/**
 * \file      dia_ConfigNotifier.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      31.01.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */


#ifndef __INCLUDED_DIA_CONFIG_NOTIFIER__
#define __INCLUDED_DIA_CONFIG_NOTIFIER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_PROPERTY__
#include "dia_Property.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include "common/framework/config/dia_defsConfig.h"
#endif


class dia_ConfigNotifier
{
public:
   //! default class constructor
   dia_ConfigNotifier ( tCString name, tU32 propID = DIA_PROP_INVALID_IDENTIFIER );
   //! class destructor
   virtual ~dia_ConfigNotifier ( void );

   //! return the name of the config notifier object
   tCString getName ( void ) const { return mConfigNotifierName; }
   //! check if the given property is handled by the notifier object
   bool queryProperty ( tU32 propID ) const;
   //! return the list of property identifiers managed by the notifier object
   tDiaResult getProperties ( std::vector<tU32>& props ) const;

   //! add a property to the list of monitored properties
   tDiaResult addProperty ( tU32 propID );
   //! remove a property from the list of monitored properties
   tDiaResult removeProperty ( tU32 propID );

   //! send notification for property propID to system settings listener identified by systemSetID
   virtual tDiaResult onPropertyUpdate ( tU32 propID ) = 0;

protected:
   //! default class constructor
   dia_ConfigNotifier ( void );

protected:
   //! name for this feature
   tCString mConfigNotifierName;
   //! list of monitored properties
   std::map<tU32,dia_Property> mPropRep;
};

#endif /* __INCLUDED_DIA_CONFIG_NOTIFIER__ */
