#ifndef __INCLUDED_DIA_DEFS_COMMON__
#define __INCLUDED_DIA_DEFS_COMMON__

#define DIA_C_U8_SRVDISPATCHER_MAX_ARGS                 ((tU8)  2)
#define DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED     ((tU16) 0xFFFF)

#define DIA_C_U16_DATA_DOWNLOAD_BLOCK_MAX_BYTES         ((tU16) 0x0400)

// 1 byte service identifiers                                                    ( SID )
#define  DIA_C_U8_UDS_SID_INVALID                                           ((tU8) 0x00)
#define  DIA_C_U8_UDS_SID_SESSION_CONTROL                                   ((tU8) 0x10)
#define  DIA_C_U8_UDS_SID_ECU_RESET                                         ((tU8) 0x11)
#define  DIA_C_U8_UDS_SID_CLEAR_DIAG_INFO                                   ((tU8) 0x14)
#define  DIA_C_U8_UDS_SID_READ_DTC_INFO                                     ((tU8) 0x19)
#define  DIA_C_U8_UDS_SID_READ_DATA_BY_LOCAL_IDENTIFIER                     ((tU8) 0x21)
#define  DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER                           ((tU8) 0x22)
#define  DIA_C_U8_UDS_SID_READ_MEMORY_BY_ADDRESS                            ((tU8) 0x23)
#define  DIA_C_U8_UDS_SID_SECURITY_ACCESS                                   ((tU8) 0x27)
#define  DIA_C_U8_UDS_SID_COMMUNICATION_CONTROL                             ((tU8) 0x28)
#define  DIA_C_U8_UDS_SID_WRITE_DATA_BY_IDENTIFIER                          ((tU8) 0x2E)
#define  DIA_C_U8_UDS_SID_IOCONTROL_BY_LOCAL_IDENTIFIER                     ((tU8) 0x30)
#define  DIA_C_U8_UDS_SID_WRITE_DATA_BY_LOCAL_IDENTIFIER                    ((tU8) 0x3B)
#define  DIA_C_U8_UDS_SID_IOCONTROL_BY_IDENTIFIER                           ((tU8) 0x2F)
#define  DIA_C_U8_UDS_SID_ROUTINE_CONTROL                                   ((tU8) 0x31)
#define  DIA_C_U8_UDS_SID_REQUEST_DOWNLOAD                                  ((tU8) 0x34)
#define  DIA_C_U8_UDS_SID_REQUEST_UPLOAD                                    ((tU8) 0x35)
#define  DIA_C_U8_UDS_SID_TRANSFER_DATA                                     ((tU8) 0x36)
#define  DIA_C_U8_UDS_SID_REQUEST_TRANSFER_EXIT                             ((tU8) 0x37)
#define  DIA_C_U8_UDS_SID_REQUEST_FILE_TRANSFER                             ((tU8) 0x38)
#define  DIA_C_U8_UDS_SID_WRITE_MEMORY_BY_ADDRESS                           ((tU8) 0x3D)
#define  DIA_C_U8_UDS_SID_CONTROL_DTC_SETTING                               ((tU8) 0x85)
#define  DIA_C_U8_UDS_SID_RESPONSE_ON_EVENT                                 ((tU8) 0x86)

// service identifier for internal requests
#define  DIA_C_U8_UDS_SID_DIAG_COMMAND                                      ((tU8) 0xFD)

//
// common diagnostic service identifiers (Robert Bosch Car Multimedia)
//

// #### DEPRECATED - PLEASE USE DEFINES FROM FOLLOWING BLOCK INSTEAD ####
#define DIAGLIB_SYSTEM_SET_TYPE_MASK_HMI                                   ((tU32) 0x00000001)
#define DIAGLIB_SYSTEM_SET_TYPE_MASK_TEF                                   ((tU32) 0x00000002)
#define DIAGLIB_SYSTEM_SET_TYPE_MASK_CODING                                ((tU32) 0x00000004)
#define DIAGLIB_SYSTEM_SET_TYPE_MASK_CALIBRATION                           ((tU32) 0x00000008)
#define DIAGLIB_SYSTEM_SET_TYPE_MASK_CUSTOMER                              ((tU32) 0x00000010)
#define DIAGLIB_SYSTEM_SET_TYPE_MASK_USRMGMT_RESET_ALL                     ((tU32) 0x00000020)
#define DIAGLIB_SYSTEM_SET_TYPE_MASK_USRMGMT_RESET_USER                    ((tU32) 0x00000040)
#define DIAGLIB_SYSTEM_SET_TYPE_MASK_USRMGMT_RESET_BANK                    ((tU32) 0x00000080)
#define DIAGLIB_SYSTEM_SET_TYPE_MASK_USRMGMT_SWITCH_USER                   ((tU32) 0x00000100)
#define DIAGLIB_SYSTEM_SET_TYPE_MASK_USRMGMT_SWITCH_BANK                   ((tU32) 0x00000200)

#define DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_HMI                             ((tU32) 0x00000001)
#define DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PRODUCTION                      ((tU32) 0x00000002)
#define DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_ALIGNMENT                       ((tU32) 0x00000004)
#define DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_CALIBRATION                     ((tU32) 0x00000008)
#define DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_CUSTOMER                        ((tU32) 0x00000010)
#define DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_USRMGMT_RESET_ALL               ((tU32) 0x00000020)
#define DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_USRMGMT_RESET_USER              ((tU32) 0x00000040)
#define DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_USRMGMT_RESET_BANK              ((tU32) 0x00000080)
#define DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_USRMGMT_SWITCH_USER             ((tU32) 0x00000100)
#define DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_USRMGMT_SWITCH_BANK             ((tU32) 0x00000200)
#define DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_USRMGMT_SAVE_BANK               ((tU32) 0x00000400)
#define DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_TEST                            ((tU32) 0x00000800)
#define DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PROJECT_1                       ((tU32) 0x00001000)
#define DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PROJECT_2                       ((tU32) 0x00002000)
#define DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PROJECT_3                       ((tU32) 0x00004000)
#define DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PROJECT_4                       ((tU32) 0x00008000)
#define DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PROJECT_5                       ((tU32) 0x00010000)
#define DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PROJECT_6                       ((tU32) 0x00020000)
#define DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PROJECT_7                       ((tU32) 0x00040000)
#define DIA_C_U32_SYSTEM_SETTING_TYPE_MASK_PROJECT_8                       ((tU32) 0x00080000)

// predefined system setting type names
#define DIA_C_STR_SYSTEM_SETTING_TYPE_UNKNOWN                              ((tCString) "DIA_SYSSET_TYPE_UNKNOWN")
#define DIA_C_STR_SYSTEM_SETTING_TYPE_HMI                                  ((tCString) "DIA_SYSSET_TYPE_HMI")
#define DIA_C_STR_SYSTEM_SETTING_TYPE_PRODUCTION                           ((tCString) "DIA_SYSSET_TYPE_PRODUCTION")
#define DIA_C_STR_SYSTEM_SETTING_TYPE_ALIGNMENT                            ((tCString) "DIA_SYSSET_TYPE_ALIGNMENT")
#define DIA_C_STR_SYSTEM_SETTING_TYPE_CALIBRATION                          ((tCString) "DIA_SYSSET_TYPE_CALIBRATION")
#define DIA_C_STR_SYSTEM_SETTING_TYPE_CUSTOMER                             ((tCString) "DIA_SYSSET_TYPE_CUSTOMER")
#define DIA_C_STR_SYSTEM_SETTING_TYPE_USRMGMT_RESET_ALL                    ((tCString) "DIA_SYSSET_TYPE_USERMGMT_RESET_ALL")
#define DIA_C_STR_SYSTEM_SETTING_TYPE_USRMGMT_RESET_USER                   ((tCString) "DIA_SYSSET_TYPE_USERMGMT_RESET_USER")
#define DIA_C_STR_SYSTEM_SETTING_TYPE_USRMGMT_RESET_BANK                   ((tCString) "DIA_SYSSET_TYPE_USERMGMT_RESET_BANK")
#define DIA_C_STR_SYSTEM_SETTING_TYPE_USRMGMT_SWITCH_USER                  ((tCString) "DIA_SYSSET_TYPE_USERMGMT_SWITCH_USER")
#define DIA_C_STR_SYSTEM_SETTING_TYPE_USRMGMT_SWITCH_BANK                  ((tCString) "DIA_SYSSET_TYPE_USERMGMT_SWITCH_BANK")
#define DIA_C_STR_SYSTEM_SETTING_TYPE_USRMGMT_SAVE_BANK                    ((tCString) "DIA_SYSSET_TYPE_USERMGMT_SAVE_BANK")
#define DIA_C_STR_SYSTEM_SETTING_TYPE_DIAGNOSTICS_INTERNAL                 ((tCString) "DIA_SYSSET_TYPE_DIAGNOSTICS_INTERNAL")
#define DIA_C_STR_SYSTEM_SETTING_TYPE_TEST                                 ((tCString) "DIA_SYSSET_TYPE_TEST")

// hash codes for the predefined system setting type names defined above
// shw2abt: to calculate your hash use the existing tool fc_diagnosis/tools/Hasher
#define DIA_C_UID_SYSTEM_SETTING_TYPE_UNKNOWN                              ((dia_UID) 0x0c5af56d)
#define DIA_C_UID_SYSTEM_SETTING_TYPE_HMI                                  ((dia_UID) 0x8f122f5b)
#define DIA_C_UID_SYSTEM_SETTING_TYPE_PRODUCTION                           ((dia_UID) 0xe64611a4)
#define DIA_C_UID_SYSTEM_SETTING_TYPE_ALIGNMENT                            ((dia_UID) 0xf25140bc)
#define DIA_C_UID_SYSTEM_SETTING_TYPE_CALIBRATION                          ((dia_UID) 0x4f8c40a5)
#define DIA_C_UID_SYSTEM_SETTING_TYPE_CUSTOMER                             ((dia_UID) 0x2906012f)
#define DIA_C_UID_SYSTEM_SETTING_TYPE_USRMGMT_RESET_ALL                    ((dia_UID) 0x80ff3acb)
#define DIA_C_UID_SYSTEM_SETTING_TYPE_USRMGMT_RESET_USER                   ((dia_UID) 0xa0f1a8f1)
#define DIA_C_UID_SYSTEM_SETTING_TYPE_USRMGMT_RESET_BANK                   ((dia_UID) 0xa0e6f24e)
#define DIA_C_UID_SYSTEM_SETTING_TYPE_USRMGMT_SWITCH_USER                  ((dia_UID) 0x86b25880)
#define DIA_C_UID_SYSTEM_SETTING_TYPE_USRMGMT_SWITCH_BANK                  ((dia_UID) 0x86a7a1dd)
#define DIA_C_UID_SYSTEM_SETTING_TYPE_USRMGMT_SAVE_BANK                    ((dia_UID) 0x2c1a355a)
#define DIA_C_UID_SYSTEM_SETTING_TYPE_DIAGNOSTICS_INTERNAL                 ((dia_UID) 0x3bb131f1)
#define DIA_C_UID_SYSTEM_SETTING_TYPE_TEST                                 ((dia_UID) 0xd0d85ba0)


// predefined system setting type names
#define DIA_C_STR_REMOTE_CONTROL_AREA_UNKNOWN                              ((tCString) "DIA_REMOTECTRL_AREA_UNKNOWN")
#define DIA_C_STR_REMOTE_CONTROL_AREA_SYSTEM_SETTING                       ((tCString) "DIA_REMOTECTRL_AREA_SYSTEM_SETTING")

// hash codes for the predefined system setting type names defined above
#define DIA_C_UID_REMOTE_CONTROL_AREA_UNKNOWN                              ((dia_UID) 0x9ea6923a)
#define DIA_C_UID_REMOTE_CONTROL_AREA_SYSTEM_SETTING                       ((dia_UID) 0x2be2bb6c)

// predefined system setting type names
#define DIA_C_STR_REMOTE_CONTROL_MODE_UNKNOWN                              ((tCString) "DIA_REMOTECTRL_MODE_UNKNOWN")
#define DIA_C_STR_REMOTE_CONTROL_MODE_ACTIVE                               ((tCString) "DIA_REMOTECTRL_MODE_ACTIVE")
#define DIA_C_STR_REMOTE_CONTROL_MODE_INACTIVE                             ((tCString) "DIA_REMOTECTRL_MODE_INACTIVE")

// hash codes for the predefined system setting type names defined above
#define DIA_C_UID_REMOTE_CONTROL_MODE_UNKNOWN                              ((dia_UID) 0x27e005e6)
#define DIA_C_UID_REMOTE_CONTROL_MODE_ACTIVE                               ((dia_UID) 0xa3405372)
#define DIA_C_UID_REMOTE_CONTROL_MODE_INACTIVE                             ((dia_UID) 0xf8b2a7e9)

// ---- Diagnosis ----
#define DIA_C_U16_DID_RBCM_DEVICE_PRODUCTION_TIME                          ((tU16) 0xD010)
#define DIA_C_U16_ID_RTCTRL_JTAG_ID_AND_SECURITY_BYTE_CONFIGURE            ((tU16) 0x3150)
#define DIA_C_U16_ID_RTCTRL_JTAG_ID_AND_SECURITY_BYTE_VERIFY               ((tU16) 0x3151)

// ---- LCM ----
#define DIA_C_U16_DID_RBCM_SYSTEM_OPERATION_TIME                           ((tU16) 0xB101) // DID for systemOperationTime
#define DIA_C_U16_DID_RBCM_SYSTEM_RESET_INFORMATION                        ((tU16) 0x1000)
#define DIA_C_U16_DID_RBCM_SPM_HISTORY_RESET                               ((tU16) 0x1030)
#define DIA_C_U16_DID_RBCM_SPM_HISTORY_WAKEUP                              ((tU16) 0x1031)
#define DIA_C_U16_DID_RBCM_SPM_HISTORY_STATE                               ((tU16) 0x1032)
#define DIA_C_U16_DID_RBCM_SPM_HISTORY_ERROR_STATE_01                      ((tU16) 0x1033)
#define DIA_C_U16_DID_RBCM_SPM_HISTORY_ERROR_STATE_02                      ((tU16) 0x1034)
#define DIA_C_U16_DID_RBCM_SPM_HISTORY_ERROR_STATE_03                      ((tU16) 0x1035)
#define DIA_C_U16_DID_RBCM_SPM_HISTORY_ERROR_STATE_04                      ((tU16) 0x1036)
#define DIA_C_U16_DID_RBCM_SPM_HISTORY_ERROR_STATE_05                      ((tU16) 0x1037)
#define DIA_C_U16_DID_RBCM_RTCTRL_RESET_SYSTEM_OPERATION_TIME              ((tU16) 0xD010)
#define DIA_C_U16_DID_RBCM_RTCTRL_RESET_SYSTEM_RESET_INFORMATION           ((tU16) 0xD011)
#define DIA_C_U16_DID_RBCM_RTCTRL_LCM_START_ALTERNATIVE_SOFTWARE           ((tU16) 0xD003)
#define DIA_C_U16_DID_RBCM_RTCTRL_LCM_START_SOFTWARE_UPDATE                ((tU16) 0x3300)
#define DIA_C_U16_DID_RBCM_SYSTEM_REMOTE_CONTROL                           ((tU16) 0xB100)
#define DIA_C_U16_DID_RBCM_POWER_SUPPLY_VOLTAGE_STATE                      ((tU16) 0xB110)
#define DIA_C_U16_DID_RBCM_POWER_SUPPLY_VOLTAGE                            ((tU16) 0xB111)

#define DIA_C_U16_DID_RBCM_POWER_SUPPLY_VOLTAGE_STATE_COUNTER              ((tU16) 0xB112)
#define DIA_C_U16_DID_RBCM_POWER_SUPPLY_VOLTAGE_HISTOGRAM                  ((tU16) 0xB113)
#define DIA_C_U16_DID_RBCM_AVERAGE_CPU_LOAD                                ((tU16) 0xB114)
#define DIA_C_U16_DID_RBCM_MAXIMUM_RAM_CONSUMPTION                         ((tU16) 0xB115)
#define DIA_C_U16_DID_RBCM_STARTUP_TIME_STATISTIC                          ((tU16) 0xB116)

#define DIA_C_U16_DID_RBCM_READ_RESET_INFORMATION_FOR_SW_VERSION           ((tU16) 0xD014)
#define DIA_C_U16_DID_RBCM_READ_WAKEUP_HISTORY_FOR_SW_VERSION              ((tU16) 0xD015)
#define DIA_C_U16_DID_RBCM_READ_RESET_HISTORY_FOR_SW_VERSION               ((tU16) 0xD016)
#define DIA_C_U16_DID_RBCM_READ_STATE_HISTORY_FOR_SW_VERSION               ((tU16) 0xD017)
#define DIA_C_U16_DID_RBCM_READ_ERROR_STATE_HISTORY_FOR_SW_VERSION         ((tU16) 0xD018)
#define DIA_C_U16_DID_RBCM_READ_SYSTEM_OPERATION_TIME_FOR_SW_VERSION       ((tU16) 0xD019)
#define DIA_C_U16_DID_RBCM_READ_AVERAGE_CPU_LOAD_FOR_SW_VERSION            ((tU16) 0xD01A)
#define DIA_C_U16_DID_RBCM_READ_MAXIMUM_RAM_CONSUMPTION_FOR_SW_VERSION     ((tU16) 0xD01B)
#define DIA_C_U16_DID_RBCM_READ_STARTUP_TIME_STATISTIC_FOR_SW_VERSION      ((tU16) 0xD01C)

// ---- HEAT CONTROL ----
#define DIA_C_U16_DID_RBCM_DISPLAY_TEMPERATURE                             ((tU16) 0x6204)
#define DIA_C_U16_DID_RBCM_GYRO_TEMPERATURE                                ((tU16) 0x6370)
#define DIA_C_U16_DID_RBCM_EMMC_TEMPERATURE                                ((tU16) 0x6380) // DID for EMMC_Temperature
#define DIA_C_U16_DID_RBCM_GNSS_TEMPERATURE                                ((tU16) 0x6304)
#define DIA_C_U16_DID_RBCM_OPTICAL_DRIVE_TEMPERATURE                       ((tU16) 0x6350)
#define DIA_C_U16_DID_RBCM_EMMC_TEMPERATURE_THRESHOLDS                     ((tU16) 0x8110)
#define DIA_C_U16_DID_RBCM_THERMAL_MGNT_TEMPERATURE_THRESHOLDS             ((tU16) 0x8111)
#define DIA_C_U16_DID_RBCM_HEATSINK_TEMPERATURE                            ((tU16) 0x6381)
#define DIA_C_U16_DID_RBCM_AMPLIFIER_TEMPERATURE                           ((tU16) 0x6382)
#define DIA_C_U16_DID_RBCM_AMP_TEMPERATURE                                 ((tU16) 0x6382)
#define DIA_C_U16_DID_RBCM_V850_TEMPERATURE                                ((tU16) 0x6383)
#define DIA_C_U16_DID_RBCM_PANEL_TEMPERATURE                               ((tU16) 0x6384)
#define DIA_C_U16_DID_RBCM_DVD_DRIVER_TEMPERATURE                          ((tU16) 0x6385)
#define DIA_C_U16_DID_RBCM_GPS_TEMPERATURE                                 ((tU16) 0x6386)
#define DIA_C_U16_DID_RBCM_IMX_TEMPERATURE                                 ((tU16) 0x6387)
#define DIA_C_U16_DID_RBCM_XMMODULE_TEMPERATURE                            ((tU16) 0x6388)
#define DIA_C_U16_DID_RBCM_TVMODULE_TEMPERATURE                            ((tU16) 0x6389)
#define DIA_C_U16_DID_RBCM_TVMODULESLAVE_TEMPERATURE                       ((tU16) 0x638A)
#define DIA_C_U16_DID_RBCM_PANEL2_TEMPERATURE                              ((tU16) 0x638B)
#define DIA_C_U16_DID_RBCM_FAN_SPEED                              ((tU16) 0x1084)

// ---- FIELD LOAD DATA
#define DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_EMMC                      ((tU16) 0x6610)
#define DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_HEAT_SINK                 ((tU16) 0x6611)
#define DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_GYRO                      ((tU16) 0x6612)
#define DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_DVD_DRIVE                 ((tU16) 0x6613)
#define DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_CD_DRIVE                  ((tU16) 0x6614)
#define DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_AMPLIFIER                 ((tU16) 0x6615)
#define DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_DISPLAY                   ((tU16) 0x6616)
#define DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_IMX                       ((tU16) 0x6617)
#define DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_PANEL                     ((tU16) 0x6618)
#define DIA_C_U16_DID_RBCM_TEMPERATURE_HISTOGRAM_SCC                       ((tU16) 0x6619)

#define DIA_C_U16_DID_RBCM_WRITE_NEXT_TEMPERATURE_HISTOGRAM                ((tU16) 0xE000)



// ---- TUNER ----
#define DIA_C_U16_DID_RBCM_TUNER_AMFM_RDS_PROGRAM_INFO                     ((tU16) 0x6104)
#define DIA_C_U16_DID_RBCM_TUNER_AMFM_1_POWER_SUPPLY                       ((tU16) 0x6104)
#define DIA_C_U16_DID_RBCM_TUNER_AMFM_2_POWER_SUPPLY                       ((tU16) 0x6105)
#define DIA_C_U16_DID_RBCM_TUNER_DAB_ENSEMBLE_FREQUENCY                    ((tU16) 0x6130)
#define DIA_C_U16_DID_RBCM_TUNER_DAB_FIELD_STRENGH                         ((tU16) 0x6133)
#define DIA_C_U16_DID_RBCM_TUNER_DAB_POWER_SUPPLY                          ((tU16) 0x6131)
#define DIA_C_U16_DID_RBCM_TUNER_DAB_SERVICE_ID                            ((tU16) 0x6132)
#define DIA_C_U16_DID_RBCM_TUNER_DAB_SIGNAL_QUALITY                        ((tU16) 0x6134)
//#define DIA_C_U16_DID_RBCM_TUNER_AMFM_RDS_PROGRAM_INFO                     ((tU16) 0x6104)
//#define DIA_C_U16_DID_RBCM_TUNER_DAB_ENSEMBLE_FREQUENCY                    ((tU16) 0x6130)
//#define DIA_C_U16_DID_RBCM_TUNER_DAB_FIELD_STRENGH                         ((tU16) 0x6133)
//#define DIA_C_U16_DID_RBCM_TUNER_DAB_POWER_SUPPLY                          ((tU16) 0x6131)
//#define DIA_C_U16_DID_RBCM_TUNER_DAB_SERVICE_ID                            ((tU16) 0x6132)
//#define DIA_C_U16_DID_RBCM_TUNER_DAB_SIGNAL_QUALITY                        ((tU16) 0x6134)
#define DIA_C_U16_DID_RBCM_RTCTRL_FREQUENCY_SEEK_FM                        ((tU16) 0x0254)
#define DIA_C_U16_DID_RBCM_RTCTRL_FREQUENCY_SEEK_AM                        ((tU16) 0x0255)
#define DIA_C_U16_DID_RBCM_TUNER_AMFM_SELECT_ACTIVE_TUNER                  ((tU16) 0x6100) // DID for AMFMTuner_SelectActiveTuner
#define DIA_C_U16_DID_RBCM_TUNER_AMFM_FREQUENCY                            ((tU16) 0x6101) // DID for AMFMTuner_Frequency
#define DIA_C_U16_DID_RBCM_TUNER_FM_ANTENNA_1_STATUS                       ((tU16) 0x6105) // DID for FMTuner_Antenna_1_Status
#define DIA_C_U16_DID_RBCM_TUNER_FM_ANTENNA_1_CURRENT                      ((tU16) 0x6106) // DID for FMTuner_1_AntennaCurrent
#define DIA_C_U16_DID_RBCM_TUNER_DAB_ANTENNA_STATUS                        ((tU16) 0x6135) // DID for tunerDABAntennaStatus
#define DIA_C_U16_DID_RBCM_TUNER_DAB_ANTENNA_CURRENT                       ((tU16) 0x6136) // DID for tunerDABAntennaCurrent
#define DIA_C_U16_DID_RBCM_TUNER_DRM_SERVICE_ID                            ((tU16) 0x6152) // DID for Tuner_DRMSetServiceID
#define DIA_C_U16_DID_RBCM_TUNER_DRM_ENSEMBLE_FREQUENCY                    ((tU16) 0x6150) // DID for Tuner_DRMSetEnsembleFrequency
#define DIA_C_U16_DID_AMFM_SELECT_ACTIVE_TUNER                             ((tU16) 0x6100)
#define DIA_C_U16_DID_TUNER_AMFM_FREQUENCY                                 ((tU16) 0x6101)
#define DIA_C_U16_DID_RBCM_TUNER_FM_ANTENNA_2_STATUS                       ((tU16) 0x6107) // DID for FMTuner_Antenna_2_Status
#define DIA_C_U16_DID_RBCM_TUNER_FM_ANTENNA_2_CURRENT                      ((tU16) 0x6108) // DID for FMTuner_2_AntennaCurrent
//#define DIA_C_U16_DID_RBCM_TUNER_DAB_ANTENNA_CURRENT                       ((tU16) 0x6136)
//#define DIA_C_U16_DID_RBCM_TUNER_DAB_ANTENNA_STATUS                        ((tU16) 0x6135)
#define DIA_C_U16_DID_RBCM_GENERIC_TUNER_PARAMETER_SET                     ((tU16) 0x8113)
#define DIA_C_U16_DID_RBCM_ANTENNA_PARAMETER_SET                           ((tU16) 0x8114)
#define DIA_C_U16_DID_RBCM_FM_AM_TUNER_PARAMETER_SET                       ((tU16) 0x8112)
#define DIA_C_U16_DID_RBCM_DAB_TUNER_PARAMETER_SET                         ((tU16) 0x8115)
#define DIA_C_U16_DID_RBCM_HD_PARAMETER_SET                                ((tU16) 0x8116)
#define DIA_C_U16_DID_RBCM_ANTENNA_2_PARAMETER_SET                         ((tU16) 0x811D)

#define DIA_C_U16_DID_RBCM_SXM_TUNER_CHANNEL                               ((tU16) 0x6140)
#define DIA_C_U16_DID_RBCM_SXM_TUNER_UPC                                   ((tU16) 0x6143)
#define DIA_C_U16_DID_RBCM_SXM_TUNER_SIGNAL_QUALITY                        ((tU16) 0x6144)
#define DIA_C_U16_DID_RBCM_SXM_TUNER_ANTENNA_STATUS                        ((tU16) 0x6145)
#define DIA_C_U16_DID_RBCM_SXM_TUNER_BER                                   ((tU16) 0x6146)

// ---- HMI ----
#define DIA_C_U16_DID_RBCM_HMI_LANGUAGE                                    ((tU16) 0xB101)
#define DIA_C_U16_DID_RBCM_SYSTEM_HMI_ON                                   ((tU16) 0xB000)
#define DIA_C_U16_DID_RBCM_DISPLAY_TEST_PATTERN                            ((tU16) 0x6202)

// ---- DIMMING ----
#define DIA_C_U16_DID_RBCM_DISPLAY_BACKLIGHT_ILLUMINATION                  ((tU16) 0x6203)   // DID for Display brightness
#define DIA_C_U16_DID_DISPLAY_BACKLIGHT_ILLUMINATION                       ((tU16) 0x6203)   // brightnessillumination
#define DIA_C_U16_DID_RBCM_DIMMING_PARAMETER_SET                           ((tU16) 0x8108)   // DimmingParameterSet
#define DIA_C_U16_DID_RBCM_KEY_ILLUMINATION_ALIGNMENT                      ((tU16) 0x8107)   // keyIlluminationAlignmentCoefficients
#define DIA_C_U16_DID_RBCM_KEY_ILLUMINATION_PWM                            ((tU16) 0x6211)   // keyIlluminationpwm
#define DIA_C_U16_DID_RBCM_KEY_ILLUMINATION                                ((tU16) 0x6210)   // keyIllumination
#define DIA_C_U16_DID_RBCM_WIRE_DIMMING_INFORMATION                        ((tU16) 0x1007)   // dia_SrvHandler_WireDimmingInfo_Get

// ---- INPUT HANDLING ----
#define DIA_C_U16_DID_RBCM_ENCODER_1_SELECT_COUNTER_VALUE                  ((tU16) 0x6231)
#define DIA_C_U16_DID_RBCM_ENCODER_2_VOLUME_COUNTER_VALUE                  ((tU16) 0x6232)
#define DIA_C_U16_DID_RBCM_INPUT_HDL_KEY_PRESSED                           ((tU16) 0x6230)
#define DIA_C_U16_DID_RBCM_INPUT_HDL_ENCODER_1_COUNTER_VALUE               ((tU16) 0x6231)
#define DIA_C_U16_DID_RBCM_INPUT_HDL_ENCODER_2_COUNTER_VALUE               ((tU16) 0x6232)
#define DIA_C_U16_DID_RBCM_INPUT_HDL_TOUCH_PANEL_STATUS                    ((tU16) 0x6233)
#define DIA_C_U16_DID_RBCM_INPUT_KEY_MAP_TABLE_ONE                         ((tU16) 0x8101)
#define DIA_C_U16_DID_RBCM_INPUT_KEY_MAP_TABLE_TWO                         ((tU16) 0x8102)
#define DIA_C_U16_DID_RBCM_INPUT_KEY_MAP_TABLE_THREE                       ((tU16) 0x8103)
#define DIA_C_U16_DID_RBCM_INPUT_KEY_MAP_TABLE_FOUR                        ((tU16) 0x8109)
#define DIA_C_U16_DID_RBCM_KEY_PRESSED                                     ((tU16) 0x6230)
#define DIA_C_U16_DID_RBCM_RTCTRL_TOUCHPANEL_ALIGNMENT                     ((tU16) 0x1000)
#define DIA_C_U16_DID_RBCM_TOUCH_INFO                                      ((tU16) 0x6233)
#define DIA_C_U16_DID_TOUCH_X_CO                                           ((tU16) 0x1124)
#define DIA_C_U16_DID_TOUCH_Y_CO                                           ((tU16) 0x1125)
#define DIA_C_U16_DID_RBCM_RTCTRL_TOUCH_SELFTEST                     ((tU16) 0x3055)   // DID for TouchControllerSelfTest dia_RoutineCtrlTouchSelfTest

// ---- BT OR WIFI ----
#define DIA_C_U16_DID_RBCM_BT_MAC_ADDRESS                                  ((tU16) 0x7008)
#define DIA_C_U16_DID_RBCM_BT_NAME                                         ((tU16) 0x8160)
#define DIA_C_U16_DID_RBCM_WIFI_MAC_ADDRESS                                ((tU16) 0x7009)
#define DIA_C_U16_DID_RBCM_WIFI_NAME_1                                     ((tU16) 0x8165)
#define DIA_C_U16_DID_RBCM_WIFI_NAME_2                                     ((tU16) 0x8166)
#define DIA_C_U16_DID_RBCM_IOCTRL_BLUETOOTH_MODULE_RESET                   ((tU16) 0x6362)
#define DIA_C_U16_DID_RBCM_RTCTRL_PHONESET_CONNECT_BT_DEVICE               ((tU16) 0x3045)
#define DIA_C_U16_DID_RBCM_RTCTRL_GET_WIFI_SNR                             ((tU16) 0x3100)
#define DIA_C_U16_DID_RBCM_RTCTRL_BT_LINKKEYS_DELETE                       ((tU16) 0x0257)
#define DIA_C_U16_DID_RBCM_BLUETOOTH_LINK_QUALITY                          ((tU16) 0x6361) // DID for BTSignalQuality
#define DIA_C_U16_DID_RBCM_BLUETOOTH_MODE                                  ((tU16) 0x6360) // DID for BTMode
#define DIA_C_U16_DID_RBCM_BT_SUBMODULE_SW_VERSION                         ((tU16) 0x7001)
#define DIA_C_U16_DID_RBCM_BT_SUBMODULE_HW_VERSION                         ((tU16) 0x7002)
#define DIA_C_U16_DID_RBCM_BT_SUBMODULE_HW_LOADER_VERSION                  ((tU16) 0x7003) // DID for BTSubModuleHWLoaderVersion
#define DIA_C_U16_DID_RBCM_IOCTRL_WIFI_MODE                                ((tU16) 0x6430)

// ---- SENSOR ----
#define DIA_C_U16_DID_GNSS_SATELLITE_SIG_QUALITY                           ((tU16) 0x6305)
#define DIA_C_U16_DID_RBCM_GNSS_ANTENNA_STATUS                             ((tU16) 0x6301)
#define DIA_C_U16_DID_RBCM_GNSS_ANTENNA_CURRENT                            ((tU16) 0x6302)
#define DIA_C_U16_DID_RBCM_GNSS_REC_FIRMWARE_VERSION                       ((tU16) 0x7030)
#define DIA_C_U16_DID_RBCM_GNSS_RECEIVER_STATUS                            ((tU16) 0x6306)
#define DIA_C_U16_DID_SENSOR_CONFIGURATION_ACC                             ((tU16) 0x8106)
#define DIA_C_U16_DID_SENSOR_CONFIGURATION_GNSS                            ((tU16) 0x8104)
#define DIA_C_U16_DID_SENSOR_CONFIGURATION_GYRO                            ((tU16) 0x8105)
#define DIA_C_U16_DID_SENSOR_GNSS_POS_SYSTEM                               ((tU16) 0x6307)
#define DIA_C_U16_DID_SENSOR_ACC_SELF_TEST                                 ((tU16) 0x3042)
#define DIA_C_U16_DID_SENSOR_GYRO_SELF_TEST                                ((tU16) 0x3043)

// ---- RVC ----
#define DIA_C_U16_DID_RBCM_IOCTRL_RVC_CONTROL_LINE                         ((tU16) 0x1020)
#define DIA_C_U16_DID_RBCM_RVC_CONTROL_LINE_CURRENT                        ((tU16) 0x1022)
#define DIA_C_U16_DID_RBCM_RVC_CONTROL_LINE_STATUS                         ((tU16) 0x1023)

// ---- MEDIA ----
#define DIA_C_U16_DID_RBCM_SDCARD1_MEDIA_INFO                              ((tU16) 0x6311) // DID for memoryCardReader1MediaInfo - bnl1kor
#define DIA_C_U16_DID_RBCM_SD_CARD_1_MEDIA_INFO                            ((tU16) 0x6311)
#define DIA_C_U16_DID_RBCM_SD_CARD_1_SLOT_STATE                            ((tU16) 0x6310)
#define DIA_C_U16_DID_RBCM_USB_DEVICES_INFO                                ((tU16) 0x6320)
#define DIA_C_U16_DID_RBCM_USB_POWER_SUPPLY_INFO_PORT_1                    ((tU16) 0x6321)
#define DIA_C_U16_DID_RBCM_USB_POWER_SUPPLY_INFO_PORT_2                    ((tU16) 0x6322)
#define DIA_C_U16_DID_RBCM_USB_POWER_SUPPLY_INFO_PORT_3                    ((tU16) 0x6323)
#define DIA_C_U16_DID_RBCM_USB_POWER_SUPPLY_1                              ((tU16) 0x6420) //DID for USB_1_PowerSupply
#define DIA_C_U16_DID_RBCM_USB_POWER_SUPPLY_2                              ((tU16) 0x6421) //DID for USB_2_PowerSupply
#define DIA_C_U16_DID_RBCM_USB_POWER_SUPPLY_3                              ((tU16) 0x6422) //DID for USB_2_PowerSupply
#define DIA_C_U16_DID_RBCM_IPOD_SELFTEST                                   ((tU16) 0x3040)
#define DIA_C_U16_DID_RBCM_CD_MODE_CONTROL                                 ((tU16) 0x6418)
#define DIA_C_U16_DID_RBCM_CDDA_PLAYED_TRACK                               ((tU16) 0x6121)
#define DIA_C_U16_DID_RBCM_OPTICAL_DRIVE_RESET_LINE                        ((tU16) 0x6122)
#define DIA_C_U16_DID_RBCM_OPTICAL_DRIVE_LOADER_STATUS                     ((tU16) 0x1013)
#define DIA_C_U16_DID_RBCM_MMGR_CDDRIVE_SELFTEST                           ((tU16) 0x3050)

// ---- GPIO ----
#define DIA_C_U16_DID_RBCM_ADC_AMP_CLIP_VOLTAGE                            ((tU16) 0x1102)
#define DIA_C_U16_DID_RBCM_GPIO_INPUT_ECALL_MUTE                           ((tU16) 0x1040) // DID for  reverse_gear - bnl1kor
#define DIA_C_U16_DID_RBCM_GPIO_PARKING_BRAKE                              ((tU16) 0x1045) // DID for  parking_brake - bnl1kor
#define DIA_C_U16_DID_RBCM_GPIO_REVERSE_GEAR                               ((tU16) 0x1046) // DID for  reverse_gear - bnl1kor
#define DIA_C_U16_DID_RBCM_GPIO_MICROPHONE_JACK_DETECT                     ((tU16) 0x1047) // DID for  statusExternalInputMicrophoneJackDetect_Read
#define DIA_C_U16_DID_RBCM_BT_MODULE_RESET                                 ((tU16) 0x6365)
#define DIA_C_U16_DID_RBCM_WIFI_MODULE_RESET                               ((tU16) 0x6366)
#define DIA_C_U16_DID_RBCM_GPIO_REVERSEGEAR                                ((tU16) 0x1004) // DID for  reverse_gear AIVI
#define DIA_C_U16_DID_RBCM_GPIO_ILLUMINATION_SWITCH                        ((tU16) 0x1005) // DID for  illumination_switch
// ---- DISPLAY ----
#define DIA_C_U16_DID_RBCM_ACTIVE_VIDEO_SOURCE                             ((tU16) 0x6201)

// ---- AUDIO ----
#define DIA_C_U16_DID_RBCM_AUDIO_BALANCE                                   ((tU16) 0x6413) // DID for audioBalance
#define DIA_C_U16_DID_RBCM_AUDIO_EXT_AMPLIFIER_CONT_LINE                   ((tU16) 0x6417)
#define DIA_C_U16_DID_RBCM_AUDIO_FADER                                     ((tU16) 0x6414) // DID for audioFader
#define DIA_C_U16_DID_RBCM_AUDIO_GAIN                                      ((tU16) 0x6411) // DID for audioGain
#define DIA_C_U16_DID_RBCM_AUDIO_SINK_ACTIVE                               ((tU16) 0x6417)
#define DIA_C_U16_DID_RBCM_AUDIO_LINEAR_MODE                               ((tU16) 0x6415)
#define DIA_C_U16_DID_RBCM_AUDIO_PARAMETER_SET                             ((tU16) 0x8400)
#define DIA_C_U16_DID_RBCM_AUDIO_SOURCE_ACTIVE                             ((tU16) 0x6410)
#define DIA_C_U16_DID_RBCM_AUDIO_TEST_TONE                                 ((tU16) 0x6412) // DID for audioTesttone

// ---- COMPRESSED AUDIO ----
#define DIA_C_U16_DID_RBCM_COMPRESSED_AUDIO_SELECT_TITLE                   ((tU16) 0x6416)

// ---- MICROPHONE ----
#define DIA_C_U16_DID_RBCM_MIC_PS_INFO_1                                   ((tU16) 0x1020)
#define DIA_C_U16_DID_RBCM_MIC_PS_INFO_2                                   ((tU16) 0x1021)
#define DIA_C_U16_DID_RBCM_IOCTRL_MICROPHONE_POWER_SUPPLY_1                ((tU16) 0x6263)
#define DIA_C_U16_DID_RBCM_IOCTRL_MICROPHONE_POWER_SUPPLY_2                ((tU16) 0x6264)

// ---- CHECKSUMS AND FINGERPRINTS ----
#define DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_NOR_RAW                     ((tU16) 0x3060) // DID for calculateAndVerifyChecksum_NOR_RAW
//#define DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_NOR_FFS                   ((tU16) 0x3061) // DID for calculateAndVerifyChecksum_NOR_FFS
#define DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_RAW                    ((tU16) 0x3062) // DID for calculateAndVerifyChecksum_eMMC_BIN
#define DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_FFS                    ((tU16) 0x3063) // DID for calculateAndVerifyChecksum_eMMC_FFS
#define DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_FFS_ROOT               ((tU16) 0x3063) // DID for calculateAndVerifyChecksum_eMMC_FFS_ROOT
#define DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_FFS_STATIC             ((tU16) 0x3067) // DID for calculateAndVerifyChecksum_eMMC_FFS_STATIC
#define DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_FFS_MAP_DATA           ((tU16) 0x3068) // DID for calculateAndVerifyChecksum_eMMC_FFS_MAP_DATA
#define DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_FFS_SDB                ((tU16) 0x306B) // DID for calculateAndVerifyChecksum_eMMC_FFS_SDB
#define DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_FFS_GRACENOTE          ((tU16) 0x306C) // DID for calculateAndVerifyChecksum_eMMC_FFS_GRACENOTE
#define DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_FASTBOOT               ((tU16) 0x3064) // DID for calculateAndVerifyChecksum_eMMC_FastBoot
#define DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_V850_BOOT                   ((tU16) 0x3065) // DID for calculateAndVerifyChecksum_V850_Boot
#define DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_V850_APP                    ((tU16) 0x3066) // DID for calculateAndVerifyChecksum_V850_App
#define DIA_C_U16_DID_RBCM_CM_CONFIGURATION_FINGERPRINT                    ((tU16) 0x3041)
#define DIA_C_U16_DID_RBCM_CUSTOMER_CONFIG_FINGERPRINT                     ((tU16) 0x1004)
#define DIA_C_U16_DID_RBCM_CUSTOMER_DEF_CONFIG_FINGERPRINT                 ((tU16) 0x1002)
#define DIA_C_U16_DID_RBCM_RTCTRL_GNSS_FIRMWARE_CHECKSUM                   ((tU16) 0x3069)

// ---- NAVI ----
#define DIA_C_U16_DID_NAV_DATA_COPY_PROTECTION_DEVICE_ID                   ((tU16) 0x8302)
#define DIA_C_U16_DID_NAV_DATA_COPY_PROTECTION_SEC_ECC_KEY                 ((tU16) 0x8301)
#define DIA_C_U16_DID_NAV_DEFAULT_POSITION                                 ((tU16) 0x8300)
#define DIA_C_U16_DID_WORM_ID                                              ((tU16) 0x2007)

// ---- TEF OR DEFSET ----
#define DIA_C_U16_DID_RBCM_RTCTRL_SET_SYSTEM_TO_DELIVERY_STATE             ((tU16) 0xD001)
#define DIA_C_U16_DID_RBCM_RTCTRL_FACTORY_SETTINGS                         ((tU16) 0x03E7)
#define DIA_C_U16_DID_DIAGNOSIS_RUN_IN                                     ((tU16) 0x3200)
#define DIA_C_U16_DID_DIAGNOSIS_RUN_IN_CLEAR_RESULTS                       ((tU16) 0x3201)
#define DIA_C_U16_DID_DIAGNOSIS_STRESS_TEST_1                              ((tU16) 0x3202)
#define DIA_C_U16_DID_DIAGNOSIS_STRESS_TEST_2                              ((tU16) 0x3203)
#define DIA_C_U16_DID_DIAGNOSIS_DISPLAY_SLIDESHOW                          ((tU16) 0x3204)
#define DIA_C_U16_DID_RBCM_RTCTRL_SET_DIAGNOSTICS_TO_DELIVERY_STATE        ((tU16) 0xD004)

// ---- SW UPDATE ----
#define DIA_C_U16_DID_RBCM_RTCTRL_SW_UPDATE_OF_SUBMODULE                   ((tU16) 0x1003)

// ---- IDENTIFICATION & STORED DATA ----

#define DIA_C_U16_DID_RBCM_CUSTOMER_ECU_PART_NUMBER                        ((tU16) 0x3050) // DID for CustomerECUPartNumber
#define DIA_C_U16_DID_RBCM_ECU_SPARE_PART_NUMBER                           ((tU16) 0xC000) // DID for ECUSparePartNumber
#define DIA_C_U16_DID_RBCM_ECU_SERIAL_NUMBER                               ((tU16) 0xC001) // DID for ECUSerialNumber
#define DIA_C_U16_DID_RBCM_ODX_FILE_IDENTIFIER                             ((tU16) 0xC002)
#define DIA_C_U16_DID_RBCM_ODX_FILE_VERSION                                ((tU16) 0xC003)
#define DIA_C_U16_DID_RBCM_ECU_SW_VERSION                                  ((tU16) 0xC004) // DID for ECUSWVersion
#define DIA_C_U16_DID_RBCM_ECU_HW_VERSION                                  ((tU16) 0xC005) // DID for ECUHWVersion
#define DIA_C_U16_DID_RBCM_PCB_SPARE_PART_NUMBER                           ((tU16) 0xC006) // DID for mainboardSparePartNumber
#define DIA_C_U16_DID_RBCM_PCB_SERIAL_NUMBER                               ((tU16) 0xC007) // DID for mainboardSerialNumber
#define DIA_C_U16_DID_CM_VARIANT_ID                                        ((tU16) 0xC008) // DID for ECUSparePartNumber
#define DIA_C_U16_DID_VIN_WMI_AND_VDS                                      ((tU16) 0xC009) // DID for Anonymous VIN
#define DIA_C_U16_DID_CM_UNIQUE_CONFIG_ID                                  ((tU16) 0xC012) // DID for EucUniqueConfigId
#define DIA_C_U16_DID_RBCM_ECU_UNIQUE_FIELDDATA_ID                         ((tU16) 0xC00A) // DID for ECUUniqueFieldDataId
#define DIA_C_U16_DID_CM_CUSTOMER_PCB_PARTNUMBER                           ((tU16) 0x2001)
#define DIA_C_U16_DID_CM_CUSTOMER_SOFTWARE_VERSION                         ((tU16) 0xC010)
#define DIA_C_U16_DID_RBCM_NAVI_SW_VERSION                                 ((tU16) 0x7005) // DID for NavigationSWVersion
#define DIA_C_U16_DID_RBCM_ECU_SW_BUILD_VERSION_LABEL                      ((tU16) 0x7000) // DID for ECUSWBuildVersionLabel
#define DIA_C_U16_DID_SCC_APP_SW_VERSION                                   ((tU16) 0x7020) // DID for SCC_ApplicationSoftwareVersion
#define DIA_C_U16_DID_SCC_BL_SW_VERSION                                    ((tU16) 0x7021) // DID for SCC_BootloaderSoftwareVersion
#define DIA_C_U16_DID_SCC_BM_SW_VERSION                                    ((tU16) 0x7022) // DID for SCC_BootManagerSoftwareVersion
#define DIA_C_U16_DID_SCC_APP_SW_VERSION_LABEL                             ((tU16) 0x7023) // DID for SCC_ApplicationSoftwareVersionLabel
#define DIA_C_U16_DID_SCC_BL_SW_VERSION_LABEL                              ((tU16) 0x7024) // DID for SCC_BootloaderSoftwareVersionLabel
#define DIA_C_U16_DID_SCC_BM_SW_VERSION_LABEL                              ((tU16) 0x7025) // DID for SCC_BootManagerSoftwareVersionLabel
#define DIA_C_U16_DID_ACTIVE_ALD_LEVEL                                     ((tU16) 0x8000)
#define DIA_C_U16_DID_CM_VARIANT_CODING                                    ((tU16) 0x8100)
#define DIA_C_U16_DID_CM_EXTENDED_VARIANT_CODING                           ((tU16) 0x810C)
#define DIA_C_U16_DID_RBCM_CUSTOMER_SWUP_VARIANT_INFO                      ((tU16) 0x8200)
#define DIA_C_U16_DID_CM_CONFIGURATION_INFO                                ((tU16) 0x3100)
#define DIA_C_U16_DID_CM_ADC_REF_PLUS_ACTUAL_VOLTAGE                       ((tU16) 0x8150)
#define DIA_C_U16_DID_CM_CUSTOMER_AND_BUILD_SW_VERSION                     ((tU16) 0xC011) // DID for CustomerAndBuildSWVersion Write
#define DIA_C_U16_DID_SXM_SUBBMODULE_HW_VERSION                            ((tU16) 0x7050) // DID for SXMSubModuleHWVersion
#define DIA_C_U16_DID_SXM_SUBBMODULE_SW_VERSION                            ((tU16) 0x7051) // DID for SXMSubModuleSWVersion
#define DIA_C_U16_DID_SXM_RADIO_ID                                         ((tU16) 0x7052) // DID for SXMRadioID
#define DIA_C_U16_DID_RBCM_DEVICE_MANAGER                                  ((tU16) 0x8118) // DID for DeviceManager
#define DIA_C_U16_DID_RBCM_MEDIA_PLAYER                                    ((tU16) 0x8119) // DID for Media Player
#define DIA_C_U16_DID_RBCM_DISPLAY                                         ((tU16) 0x811A) // DID for Connected Displays for SmartPhoneIntegration
#define DIA_C_U16_DID_RBCM_SMARTPHONE_INTEGRATION_DISPLAY                  ((tU16) 0x811B) // DID for SmartPhoneIntegration Display-areas
#define DIA_C_U16_DID_RBCM_SMARTPHONE_INTEGRATION                          ((tU16) 0x811C) // DID for configuration of SmartPhone component
#define DIA_C_U16_DID_VIN_WMI_AND_VDS                                      ((tU16) 0xC009) // DID for VIN_WmiAndVdsOnly

// --- ADR ----
#define DIA_C_U16_DID_ADR3_VERSION_HW                                      ((tU16) 0x7011)
#define DIA_C_U16_DID_ADR3_VERSION_HDSW                                    ((tU16) 0x7013)
#define DIA_C_U16_DID_ADR3_VERSION_HDSPL                                   ((tU16) 0x7014)
#define DIA_C_U16_DID_ADR3_VERSION_SW                                      ((tU16) 0x7010)
#define DIA_C_U16_DID_ADR3_MEMORY_ADDRESS                                  ((tU16) 0x0015)
#define DIA_C_U16_DID_ADR3_ACTUAL_CALIBRATION_DATA                         ((tU16) 0x6007)
#define DIA_C_U16_DID_ADR3_SET_SIGNAL_QUALITY                              ((tU16) 0x600D) // DID for ADR3_SetSignalQuality
#define DIA_C_U16_DID_ADR3_ANALOG_TUNERINFO_DEMODULATOR_1                  ((tU16) 0x6010)
#define DIA_C_U16_DID_ADR3_ANALOG_TUNERINFO_DEMODULATOR_2                  ((tU16) 0x6022)
#define DIA_C_U16_DID_ADR3_SET_PHYSICAL_TUNER_FREQUENCY_1                  ((tU16) 0x6000) // DID for ADR3_SetPhysicalTunerFrequency_1
#define DIA_C_U16_DID_ADR3_SET_PHYSICAL_TUNER_FREQUENCY_2                  ((tU16) 0x6001) // DID for ADR3_SetPhysicalTunerFrequency_2
#define DIA_C_U16_DID_ADR3_SET_PHYSICAL_TUNER_FREQUENCY_3                  ((tU16) 0x6002) // DID for ADR3_SetPhysicalTunerFrequency_3
#define DIA_C_U16_DID_ADR3_SET_PHYSICAL_TUNER_FREQUENCY_4                  ((tU16) 0x6003) // DID for ADR3_SetPhysicalTunerFrequency_4
#define DIA_C_U16_DID_ADR3_AMPLIFIER_POWER_STATE                           ((tU16) 0x6083) // DID for ADR3_AmplifierPowerState
#define DIA_C_U16_DID_ADR3_AUDIO_ROUTER_1                                  ((tU16) 0x6004) // DID for ADR3_AudioRouter_1
#define DIA_C_U16_DID_ADR3_BACKEND_AGC_LEVEL                               ((tU16) 0x6013) // DID for ADR3_BackendADCLevel
#define DIA_C_U16_DID_ADR3_BOOT_MODE                                       ((tU16) 0x6011) // DID for ADR3_BootMode
#define DIA_C_U16_DID_ADR3_DAB_SET_SERVICE_ID                              ((tU16) 0x6009) // DID for ADR3_DABSetServiceID
#define DIA_C_U16_DID_ADR3_FLASH_CHIP_ID                                   ((tU16) 0x7015) // DID for ADR3_FlashChipID
#define DIA_C_U16_DID_ADR3_FRONTEND_CONFIGURATION_ID                       ((tU16) 0x7012) // DID for ADR3_FrontendConfigurationID
#define DIA_C_U16_DID_ADR3_SET_VOLUME                                      ((tU16) 0x6006) // DID for ADR3_SetVolume
#define DIA_C_U16_DID_ADR3_TUNE_DEMODULATOR_1                              ((tU16) 0x6005) // DID for ADR3_TuneDemodulator_1
#define DIA_C_U16_DID_ADR3_TUNE_DEMODULATOR_2                              ((tU16) 0x600A) // DID for ADR3_TuneDemodulator_2
#define DIA_C_U16_DID_ADR3_CONTROL_FRONTEND_CLOCK_OUTPUT                   ((tU16) 0x600B) // DID for ADR3_ControlFrontEndClockOutput
#define DIA_C_U16_DID_ADR3_AUDIO_SIGNAL_QUALITY                            ((tU16) 0x600D) // DID for ADR3_SetSignalQuality
#define DIA_C_U16_DID_ADR3_SNOOP_MODE                                      ((tU16) 0x600E) // DID for ADR3_SnoopMode
#define DIA_C_U16_DID_ADR3_SWTICH_BACKGROUND_ANTENNA                       ((tU16) 0x6082) // DID for ADR3_SwitchBackgroundAntenna
#define DIA_C_U16_DID_ADR3_DDS_CONFIGURATION                               ((tU16) 0x6081) // DID for ADR3_DDSConfiguration
#define DIA_C_U16_DID_ADR3_AUDIO_TEST_TONE                                 ((tU16) 0x6080) // DID for ADR3_AudioTesttone
#define DIA_C_U16_DID_ADR3_CALC_MEASUREMENT_VAL_DEMODULATOR_1              ((tU16) 0x3015) // DID for ADR3_DABCalcMeasurementValueDemodulator_1
#define DIA_C_U16_DID_ADR3_START_CALIBRATION                               ((tU16) 0x3012) // DID for ADR3_StartCalibration
#define DIA_C_U16_DID_ADR3_STORE_ACTUAL_CALIBRATION_DATA                   ((tU16) 0x3011) // DID for ADR3_StoreActualCalibrationDataPersistently
#define DIA_C_U16_DID_ADR3_START_SEEK                                      ((tU16) 0x3010) // DID for ADR3_StartSeek
#define DIA_C_U16_DID_ADR3_CALC_CRC                                        ((tU16) 0x3013) // DID for ADR3_CalcCrc
#define DIA_C_U16_DID_ADR3_FORMAT_FFS                                      ((tU16) 0x3014) // DID for ADR3_FormatFFS
#define DIA_C_U16_DID_ADR3_DSB_CALC_NET_TO_BER                             ((tU16) 0x3016) // DID for ADR3_DABCalcNettoBER
#define DIA_C_U16_DID_ADR3_AMPLIFIER_CONFIGURATION                         ((tU16) 0x7016) // DID for ADR3_AmplifierConfiguration
//#define DIA_C_U16_DID_ADR3_ACTUAL_CALIBRATION_DATA                         ((tU16) 0x6007)
//#define DIA_C_U16_DID_ADR3_ANALOG_TUNERINFO_DEMODULATOR_1                  ((tU16) 0x6010)
//#define DIA_C_U16_DID_ADR3_ANALOG_TUNERINFO_DEMODULATOR_2                  ((tU16) 0x6022)
#define DIA_C_U16_DID_ADR3_SET_PHYSICAL_TUNER_FREQ_1                       ((tU16) 0x6000)
#define DIA_C_U16_DID_ADR3_SET_PHYSICAL_TUNER_FREQ_2                       ((tU16) 0x6001)
#define DIA_C_U16_DID_ADR3_SET_PHYSICAL_TUNER_FREQ_3                       ((tU16) 0x6002)
#define DIA_C_U16_DID_ADR3_SET_PHYSICAL_TUNER_FREQ_4                       ((tU16) 0x6003)
//#define DIA_C_U16_DID_ADR3_TUNE_DEMODULATOR_1                              ((tU16) 0x6005)
//#define DIA_C_U16_DID_ADR3_TUNE_DEMODULATOR_2                              ((tU16) 0x600A)
//#define DIA_C_U16_DID_ADR3_AUDIO_ROUTER_1                                  ((tU16) 0x6004)
//#define DIA_C_U16_DID_ADR3_SET_VOLUME                                      ((tU16) 0x6006)
#define DIA_C_U16_DID_ADR3_ACTUAL_ALIGNMENT_VALUES                         ((tU16) 0x6007)
#define DIA_C_U16_DID_ADR3_DAB_SERVICE_ID                                  ((tU16) 0x6009)
#define DIA_C_U16_DID_ADR3_CTRL_FRONTEND_CLOCK_OUTPUT                      ((tU16) 0x600B)
//#define DIA_C_U16_DID_ADR3_SNOOP_MODE                                      ((tU16) 0x600E)
//#define DIA_C_U16_DID_ADR3_START_SEEK                                      ((tU16) 0x3010)
#define DIA_C_U16_DID_ADR3_STORE_ALIGNMENT                                 ((tU16) 0x3011)
#define DIA_C_U16_DID_ADR3_START_CALIBRATION                               ((tU16) 0x3012)
//#define DIA_C_U16_DID_ADR3_CALC_CRC                                        ((tU16) 0x3013)
//#define DIA_C_U16_DID_ADR3_FORMAT_FFS                                      ((tU16) 0x3014)
#define DIA_C_U16_DID_ADR3_DAB_CALC_MEASUREMENT_VALUE                      ((tU16) 0x3015)
#define DIA_C_U16_DID_ADR3_DAB_CALC_NETTO_BER                              ((tU16) 0x3016)
#define DIA_C_U16_DID_ADR3_CHECK_FRONTEND_REGISTER                         ((tU16) 0x3032)
#define DIA_C_U16_DID_ADR3_DRM_SET_SERVICE_ID                             ((tU16) 0x6088) // DID for ADR3_DRMSetServiceID
#define DIA_C_U16_DID_ADR3_READ_GPIO                                       ((tU16) 0x608A) //DID for ADR3_ReadGpio
#define DIA_C_U16_DID_ADR3_WRITE_GPIO                                      ((tU16) 0x608B) //DID for ADR3_WriteGpio

// ---- EARLY CONFIG ----
#define DIA_C_U16_DID_RBCM_EARLY_CONFIG_DISPLAY                            ((tU16) 0x8500)
#define DIA_C_U16_DID_RBCM_EARLY_CONFIG_TOUCH_DRIVER                       ((tU16) 0x8501)
#define DIA_C_U16_DID_RBCM_EARLY_CONFIG_TWO_DISPLAY                        ((tU16) 0x8502)
#define DIA_C_U16_DID_RBCM_EARLY_CONFIG_TOUCH_DRIVER_2                     ((tU16) 0x8503)//DID for EarlyConfig_TouchDriver2

// ---- OTHERS ----
#define DIA_C_U16_DID_RBCM_BASIC_TEST_FUNCTION                             ((tU16) 0x0047)
#define DIA_C_U16_DID_RBCM_BLOCKSIZE                                       ((tU16) 0x8210)
#define DIA_C_U16_DID_RBCM_DATASET_BLOCK_SIZE                              ((tU16) 0xB103)
#define DIA_C_U16_DID_RBCM_DIAGNOSIS_SESSION_ACTIVE                        ((tU16) 0xD100)
#define DIA_C_U16_DID_RBCM_EXTERNAL_INPUT_ACC                              ((tU16) 0x1003)
#define DIA_C_U16_DID_RBCM_EXTERNAL_INPUT_IGNTION                          ((tU16) 0x1002)
#define DIA_C_U16_DID_RBCM_FASCIA_ID                                       ((tU16) 0x7009)
#define DIA_C_U16_DID_RBCM_PRINT2DIAGNOSIS_TRACE                           ((tU16) 0xD002)
#define DIA_C_U16_DID_RBCM_RTCTRL_WRITE_DTC_TEST_RESULT                    ((tU16) 0x1010)
#define DIA_C_U16_DID_RBCM_RTCTRL_EM_ERASE                                 ((tU16) 0xD005)
#define DIA_C_U16_DID_RBCM_RTCTRL_EM_PRINT2TRACE                           ((tU16) 0xD006)
#define DIA_C_U16_DID_RBCM_RTCTRL_GET_PROC_STAT_BY_PROCESSNAME             ((tU16) 0xD012)
#define DIA_C_U16_DID_RBCM_RTCTRL_GET_PROC_STATM_BY_PROCESSNAME            ((tU16) 0xD013)
#define DIA_C_U16_DID_RBCM_RTCTRL_ECHO                                     ((tU16) 0xD01D)
#define DIA_C_U16_DID_RBCM_VIDEO_SOURCE_ACTIVE                             ((tU16) 0x6201)
#define DIA_C_U16_DID_RBCM_WIRE_SPEED_INFORMATION                          ((tU16) 0x1008)
#define DIA_C_U16_DID_RBCM_DRM_TUNER_PARAMETER_SET                         ((tU16) 0x8117)
#define DIA_C_U16_DID_RBCM_EXTERNAL_INPUT_PARKING_BRAKE                    ((tU16) 0x100A)

// ---- SYSTEM ----
#define DIA_C_U16_DID_RBCM_RTCTRL_MAINSTRESS_1                             ((tU16) 0x3202)
#define DIA_C_U16_DID_RBCM_RTCTRL_MAINSTRESS_2                             ((tU16) 0x3203)

// ---- INTERNAL COMMANDS ----
#define DIA_C_U16_DID_RBCM_TEST_CONFIG_CD_DEF_HASH                         ((tU16) 0xFD0D)
#define DIA_C_U16_DID_RBCM_TEST_CONFIG_CD_HASH                             ((tU16) 0xFD0C)
#define DIA_C_U16_DID_RBCM_TEST_CONFIG_PD_HASH                             ((tU16) 0xFD0E)
#define DIA_C_U16_DID_RBCM_TEST_INPUT_EVENT                                ((tU16) 0xFD0F)
#define DIA_C_U16_DID_RBCM_TEST_LOUDSPEAKER                                ((tU16) 0xFD10)
#define DIA_C_U16_DID_RBCM_TEST_RUN_IN                                     ((tU16) 0xFD11)
#define DIA_C_U16_DID_RBCM_TEST_VDIAG                                      ((tU16) 0xFD12)
#define DIA_C_U16_DID_RADIO_TYPE_APPROVAL_MODE                             ((tU16) 0x8169)
#define DIA_C_U16_DID_AIVI_EXT_AMP_CTRL_LINE_OUTPUT                        ((tU16) 0x1500)
#define DIA_C_U16_DID_RBCM_TEST_PDX_FLASHING                               ((tU16) 0xFD13)

// emmc
#define DIA_C_U16_DID_RBCM_EMMC_JEDEC_CID_REG                              ((tU16) 0x6630)
#define DIA_C_U16_DID_RBCM_EMMC_JEDEC_CSD_REG                              ((tU16) 0x6631)
#define DIA_C_U16_DID_RBCM_EMMC_JEDEC_ECSD_DATA                            ((tU16) 0x6632)
#define DIA_C_U16_DID_RBCM_EMMC_REFRESH_STATUS                             ((tU16) 0x6638)
#define DIA_C_U16_DID_RBCM_EMMC_WRITTEN_BYTES_COUNT                        ((tU16) 0x6639)

#define DIA_C_U16_DID_LAST_DIAG_ERROR										((tU16) 0xD001)
#endif
