#ifndef __INCLUDED_DIA_COMMON__
#define __INCLUDED_DIA_COMMON__

#include <boost/shared_ptr.hpp>
#include <boost/cstdint.hpp>

#ifdef __DIA_UNIT_TESTING__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "common/utest/dia_osal_mock.h"

#ifndef __INCLUDED_DIA_STL__
#include "common/framework/application/dia_stl.h"
#endif

#ifndef __INCLUDED_DIA_TRACE__
#include "common/framework/trace/dia_trace.h" // trace defines
#endif

// error types and codes
#ifndef __INCLUDED_DIA_ERROR__
#include "common/framework/errmgmt/dia_error.h"
#endif

#ifndef __INCLUDED_DIA_TYPES__
#include "common/framework/application/dia_types.h"
#endif

#ifndef __INCLUDED_DIA_ENUMS__
#include "common/framework/application/dia_enums.h"
#endif

#ifndef __INCLUDED_DIA_MACROS__
#include "common/framework/application/dia_macros.h"
#endif

// basic interfaces
#ifndef __INCLUDED_DIA_INTERFACE_REFCOUNTABLE__
#include "common/interfaces/dia_IRefCountable.h"
#endif

// base object for all diagnosis classes
#ifndef __INCLUDED_DIA_OBJECT__
#include "common/framework/application/dia_Object.h"
#endif

// because we are using interfaces intensively we include the relevant headers for listener classes here
#ifndef __INCLUDED_DIA_LISTENER__
#include "common/framework/application/dia_Listener.h"
#endif
#ifndef __INCLUDED_DIA_NOTIFIER__
#include "common/framework/application/dia_Notifier.h"
#endif

#ifndef __INCLUDED_DIA_OBJECT_WITH_UID__
#include <common/framework/application/dia_ObjectWithUID.h>
#endif

#ifndef __INCLUDED_DIA_DEFS_PLATFORM__
#include "common/framework/application/dia_defsPlatform.h"
#endif
#ifndef __INCLUDED_DIA_DEFS_COMMON__
#include "common/framework/application/dia_defsCommon.h"
#endif
#ifndef __INCLUDED_DIA_DEFS_PROJECT__
#include "project/framework/application/dia_defsProject.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_METHODS__
#include "common/framework/factory/dia_factoryMethods.h"
#endif

#ifndef __INCLUDED_DIA_HASH_CALCULATOR__
#include <common/framework/utils/dia_HashCalculator.h>
#endif

#ifndef __DIA_INCLUDED_STRING_COMPOSER__
#include <common/framework/utils/dia_StringComposer.h>
#endif

#ifdef _BP_TRY_BEGIN
#undef _BP_TRY_BEGIN
#define _BP_TRY_BEGIN try
#endif

#ifdef _BP_CATCH_ALL
#undef _BP_CATCH_ALL
#define _BP_CATCH_ALL catch(...)
#endif

#ifdef _BP_CATCH_END
#undef _BP_CATCH_END
#define _BP_CATCH_END
#endif

#else

//
// Prio 3 messages that have been switched off
//

//lint -e641  Warning: converting enum to int
//lint -e534  Warning: ignoring return value of function
//lint -e537  Warning: repeated include file
//lint -e750  Info:    local macro not referenced
//lint -e760  Info:    redundant macro
//lint -e763  Info:    redundant declaration for symbol
//lint -e830  Info:    location cited in prior message
//lint -e831  Info:    reference cited in prior message
//lint -e1702 Info:    operator 'operator<op>' is both an ordinary function 'std::operator<op>(...)' and a member function 'std::<iterbase>::operator<op>(...)'
//lint -e1705 Info:    static class members may be accessed by the scoping operator
//lint -e1736 Info:    redundant access specifier (public|protected|private)
//lint -e1757 Info:    discarded instance of post decrement/increment
//lint -e1774 Info:    could use dynamic_cast to downcast polymorphic type 'Type'
//lint -e1788 Info:    variable is referenced only by its constructor or destructor --> concept used for scoped traces
//lint -e766  Info:    header file 'x.h' not used in module 'y.cpp'

//lint -e553 gib2hi: ok to assume 0 for preprocessor variable, because it is only available on windows based systems
#if _MSC_VER >= 1200
#pragma warning(push, 3)
#pragma warning(disable: 4355)
#pragma warning(disable: 4250)
#endif
//lint +e553 gib2hi

#ifndef __INCLUDED_DIA_PLATFORM_OSAL_INTERFACE__
#include "common/framework/application/dia_platform_osal.h"
#endif

#ifndef __INCLUDED_DIA_EXTERN_AIL_INTERFACE__
#define __INCLUDED_DIA_EXTERN_AIL_INTERFACE__
#define  AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard
#endif

#ifndef __INCLUDED_DIA_EXTERN_AHL_INTERFACE__
#define __INCLUDED_DIA_EXTERN_AHL_INTERFACE__
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h" //lint !e451 !e537 repeatedly included header file without standard include guard
#endif

#ifndef __INCLUDED_DIA_STL__
#include "common/framework/application/dia_stl.h"
#endif

#ifndef __INCLUDED_DIA_TRACE__
#include "common/framework/trace/dia_trace.h" // trace defines
#endif

// error types and codes
#ifndef __INCLUDED_DIA_ERROR__
#include "common/framework/errmgmt/dia_error.h"
#endif

#ifndef __INCLUDED_DIA_ENUMS__
#include "common/framework/application/dia_enums.h"
#endif

#ifndef __INCLUDED_DIA_TYPES__
#include "common/framework/application/dia_types.h"
#endif

#ifndef __INCLUDED_DIA_MACROS__
#include "common/framework/application/dia_macros.h"
#endif

// basic interfaces
#ifndef __INCLUDED_DIA_INTERFACE_REFCOUNTABLE__
#include "common/interfaces/dia_IRefCountable.h"
#endif

// base object for all diagnosis classes
#ifndef __INCLUDED_DIA_OBJECT__
#include <common/framework/application/dia_Object.h>
#endif

// because we are using interfaces intensively we include the relevant headers for listener classes here
#ifndef __INCLUDED_DIA_LISTENER__
#include "common/framework/application/dia_Listener.h"
#endif
#ifndef __INCLUDED_DIA_NOTIFIER__
#include "common/framework/application/dia_Notifier.h"
#endif

#ifndef __INCLUDED_DIA_OBJECT_WITH_UID__
#include <common/framework/application/dia_ObjectWithUID.h>
#endif

#ifndef __INCLUDED_SYSTEM_ADAPTER_DATA_TYPES__
#include "common/depricated/SystemAdapter/dia_DataTypes.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_PLATFORM__
#include "common/framework/application/dia_defsPlatform.h"
#endif
#ifndef __INCLUDED_DIA_DEFS_COMMON__
#include "common/framework/application/dia_defsCommon.h"
#endif
#ifndef __INCLUDED_DIA_DEFS_PROJECT__
#include "project/framework/application/dia_defsProject.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_METHODS__
#include "common/framework/factory/dia_factoryMethods.h"
#endif

#ifndef __INCLUDED_DIA_HASH_CALCULATOR__
#include <common/framework/utils/dia_HashCalculator.h>
#endif

#ifndef __DIA_INCLUDED_STRING_COMPOSER__
#include <common/framework/utils/dia_StringComposer.h>
#endif

#endif // __DIA_UNIT_TESTING

#define DIA_NEW new
#define DIA_DELETE delete
#define DIA_NULL 0
#define DIA_PARAMETER_INTENTIONALLY_UNUSED(x) (void)(x)

#ifdef VARIANT_S_FTR_ENABLE_64_BIT_SUPPORT

#ifdef USE_BOOST_ANY

#define AUX_WRAPPER_NAME int_
#include <boost/any.hpp>
typedef boost::any tArgsType;
typedef boost::any tCookieType;

#else

typedef intptr_t tArgsType;
typedef intptr_t tCookieType;

#endif

#else

typedef void* tArgsType;
typedef void* tCookieType;

#endif

namespace dia
{
#ifdef VARIANT_S_FTR_ENABLE_64_BIT_SUPPORT

#ifdef USE_BOOST_ANY
   template <typename T> T* UnsafeVoidCast(tCookieType& v) {return boost::any_cast<T*>(v);}
   template <typename T> T VoidCast(tArgsType& v) {return boost::any_cast<T>(v);}
   template <typename T> T VoidCast(tArgsType const& v) {return boost::any_cast<T>(v);}
   inline bool isArgEmpty(tArgsType a) {return a.empty();}
   inline bool isCookieEmpty(tCookieType c) {return c.empty();}
#else
   template <typename T> T* UnsafeVoidCast(tCookieType& v) {return reinterpret_cast<T*>(v);}
   template <typename T> T VoidCast(tArgsType& v) {return reinterpret_cast<T>(v);}
   template <typename T> T VoidCast(tArgsType const& v) {return reinterpret_cast<T>(v);}
   template <> inline tU32 VoidCast(tArgsType& v) {return (tU32)(v & 0xffffffff);}
   template <> inline tU32 VoidCast(tArgsType const& v) {return (tU32)(v & 0xffffffff);}
   template <> inline tU8 VoidCast(tArgsType& v) {return (tU8)(v & 0xff);}
   template <> inline tU8 VoidCast(tArgsType const& v) {return (tU8)(v & 0xff);}
   inline bool isArgEmpty(tArgsType a) {return a == 0;}
   inline bool isCookieEmpty(tCookieType c) {return c == 0;}
#endif

#else
   template <typename T> T* UnsafeVoidCast(tCookieType& v) {return reinterpret_cast<T*>(v);}
   template <typename T> T VoidCast(tArgsType& v) {return reinterpret_cast<T>(v);}
   template <typename T> T VoidCast(tArgsType const& v) {return reinterpret_cast<T>(v);}
   template <> inline tU32 VoidCast(tArgsType& v) {return (tU32)((tU32)v & 0xffffffff);}
   template <> inline tU32 VoidCast(tArgsType const& v) {return (tU32)((tU32)v & 0xffffffff);}
   template <> inline tU8 VoidCast(tArgsType& v) {return (tU8)((tU32)v & 0xff);}
   template <> inline tU8 VoidCast(tArgsType const& v) {return (tU8)((tU32)v & 0xff);}
   inline bool isArgEmpty(tArgsType a) {return a == 0;}
   inline bool isCookieEmpty(tCookieType c) {return c == 0;}
#endif
}

#endif

