/*
 * dia_VideoSourceControlPluginHMI.cpp
 *
 *  Created on: 01.07.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include <common/framework/sysadapters/dia_SystemAdapterFacade.h>
#endif

#ifndef __INCLUDED_DIA_VIDEO_SOURCE_CONTROL__
#include <common/framework/application/dia_VideoSourceControl.h>
#endif

#ifndef __INCLUDED_DIA_VIDEO_SOURCE_CONTROL_PLUGIN_HMI__
#include <common/framework/application/dia_VideoSourceControlPluginHMI.h>
#endif

//-----------------------------------------------------------------------------

dia_VideoSourceControlPluginHMI::dia_VideoSourceControlPluginHMI ( void )
   : dia_VideoSourceControlPlugin ( "dia_VideoSourceControlPluginHMI", DIA_EN_VIDEO_SOURCE_ID_HMI )
{
   dia_tclFnctTrace oTrace("dia_VideoSourceControlPluginHMI::dia_VideoSourceControlPluginHMI()");
}

//-----------------------------------------------------------------------------

dia_VideoSourceControlPluginHMI::~dia_VideoSourceControlPluginHMI ( void )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_VideoSourceControlPluginHMI::startVideoStreaming ( void )
{
   dia_tclFnctTrace oTrace("dia_VideoSourceControlPluginHMI::startVideoStreaming()");

   dia_VideoSourceControl* pVideoSrvControl = getInstanceOfVideoSourceControl();
   if ( pVideoSrvControl )
   {
      pVideoSrvControl->vOnVideoStreamingStarted(this,DIA_SUCCESS);
   }

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_VideoSourceControlPluginHMI::stopVideoStreaming ( void )
{
   dia_tclFnctTrace oTrace("dia_VideoSourceControlPluginHMI::stopVideoStreaming()");

   dia_VideoSourceControl* pVideoSrvControl = getInstanceOfVideoSourceControl();
   if ( pVideoSrvControl )
   {
      pVideoSrvControl->vOnVideoStreamingStopped(this,DIA_SUCCESS);
   }

   return DIA_SUCCESS;
}
