/*
 * dia_VideoSourceControlPlugin.cpp
 *
 *  Created on: 01.07.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_VIDEO_SOURCE_CONTROL__
#include "common/framework/application/dia_VideoSourceControl.h"
#endif

#ifndef __INCLUDED_DIA_VIDEO_SOURCE_CONTROL_PLUGIN__
#include "common/framework/application/dia_VideoSourceControlPlugin.h"
#endif

//-----------------------------------------------------------------------------

dia_VideoSourceControlPlugin::dia_VideoSourceControlPlugin (
      tCString name,
      dia_eVideoSourceID id
   )
   : mPluginID(id)
{
   if (NULL!=name)
   {
      (void)strncpy( (char*)mPluginName, (const char*)name, DIA_PLUGIN_NAME_BUFF_LEN );
      mPluginName[DIA_PLUGIN_NAME_BUFF_LEN-1] = 0; //added zero manually
   }
   else
   {
      mPluginName[0] = 0;
   }
}

//-----------------------------------------------------------------------------

dia_VideoSourceControlPlugin::dia_VideoSourceControlPlugin ( void )
   : mPluginID(DIA_EN_VIDEO_SOURCE_ID_UNKNOWN)
{
   mPluginName[0] = 0;
}

//-----------------------------------------------------------------------------

dia_VideoSourceControlPlugin::~dia_VideoSourceControlPlugin ( void )
{}

//-----------------------------------------------------------------------------

const tS8*
dia_VideoSourceControlPlugin::getName ( void ) const
{
   return &mPluginName[0];
}

//-----------------------------------------------------------------------------

dia_eVideoSourceID
dia_VideoSourceControlPlugin::eGetType ( void ) const
{
   return mPluginID;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_VideoSourceControlPlugin::startVideoStreaming ( void )
{
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_VideoSourceControlPlugin::stopVideoStreaming ( void )
{
   return DIA_SUCCESS;
}
