/*
 * dia_VideoSourceControl.h
 *
 *  Created on: 01.07.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_VIDEO_SOURCE_CONTROL__
#define __INCLUDED_DIA_VIDEO_SOURCE_CONTROL__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_VIDEOSOURCECONTROLFSM__
#include "common/framework/fsm/generated/dia_VideoSourceControlFSM.h"
#endif

#ifndef __INCLUDED_DIA_VIDEO_SOURCE_CONTROL_PLUGIN__
#include "common/framework/application/dia_VideoSourceControlPlugin.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_VIDEOSOURCECONTROL__
#include "common/interfaces/dia_IVideoSourceControl.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_VIDEOMANAGER_LISTENER__
#include "common/interfaces/dia_IVideoManagerListener.h"
#endif

class dia_VideoSourceControlPlugin;

class dia_VideoSourceControl
   : public dia_IVideoSourceControl,
     public dia_IVideoManagerListenerImpl,
     protected dia_VideoSourceControlFSM::FsmBehaviour
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_VideoSourceControl);
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_VideoSourceControl);

   struct dia_VideoSourceInfo
   {
      dia_VideoSourceInfo ( void ) : mSrcID(DIA_EN_VIDEO_SOURCE_ID_UNKNOWN), mPluginRef(0) {}

      void reset ( void ) { mSrcID = DIA_EN_VIDEO_SOURCE_ID_UNKNOWN; mPluginRef = 0; }

      dia_eVideoSourceID mSrcID;
      dia_VideoSourceControlPlugin* mPluginRef;
   };

public:
   //! install a signal handler
   tDiaResult adddVideoSourceControlPlugin ( dia_VideoSourceControlPlugin* pPlugin );
   //! install a signal handler
   tDiaResult removeVideoSourceControlPlugin ( dia_eVideoSourceID type );

   //! activate the remote control of the ECU
   virtual tDiaResult activateVideoSource ( dia_eVideoSourceID srcID );
   //! retrieve the current remote control state
   virtual dia_eVideoSourceID getActiveVideoSource ( void );
//   //! retrieve the current remote control state
//   virtual void vOnVideoSourceControlPluginUpdate ( dia_VideoSourceControlPlugin& plugin );

   //! notification about video source connection status update
   virtual void vOnConnectionStatusUpdate ( dia_eVideoManagerDestinationID destID, dia_eVideoDestinationType destType, dia_eVideoSourceConnectionStatus status );
   //! notification about a video source connection failure
   virtual void vOnConnectionError ( tDiaResult errorCode );
   //! notification about the currently activated video source
   virtual void vOnActiveVideoSource ( dia_eVideoDestinationType destType, dia_eVideoManagerDestinationID destID );
   //! notification about an error after active video source was requested
   virtual void vOnActiveVideoSourceError ( dia_eVideoDestinationType destType, tDiaResult errorCode );
   //! notification that video streaming is started. In case of error error code is delivered in parameter resultCode
   virtual void vOnVideoStreamingStarted ( dia_VideoSourceControlPlugin* pPlugin, tDiaResult resultCode );
   //! notification that video streaming is stopped. In case of error error code is delivered in parameter resultCode
   virtual void vOnVideoStreamingStopped ( dia_VideoSourceControlPlugin* pPlugin, tDiaResult resultCode );

   //! notification about video source connection status update
   virtual void vOnDisConnectionAllStatusUpdate ( void );

   //! reset FSM on timeout
   virtual void resetFSMTimeout ( void );

protected:
   //! constructor
   dia_VideoSourceControl ( void );
   //! destructor
   virtual ~dia_VideoSourceControl ( void );

   //! setup (create objects,...)
   tDiaResult setup ( void );
   //! tear down (destroy objects,...)
   tDiaResult tearDown ( void );

   void sendUpdate ( void ) const;

   // FSM actions
   virtual void vFsmReset ( void* pArg );
   virtual void vFsmSetErrCode_TimeExpired ( void* pArg );
   virtual void vFsmSetRequestedVideoSource ( void* pArg );
   virtual void vFsmSetErrCode_InvalidVideoSource ( void* pArg );
   virtual void vFsmGetCurrentlyActivatedVideoSource ( void* pArg );
   virtual void vFsmStopActiveVideoStream ( void* pArg );
   virtual void vFsmConnectRequestedVideoSource ( void* pArg );
   virtual void vFsmDisconnectActiveVideoSource ( void* pArg );
   virtual void vFsmStartRequestedVideoStream ( void* pArg );
   virtual void vFsmSetActiveVideoSource ( void* pArg );
   virtual void vFsmVideoSourceActivated ( void* pArg );

   // FSM guards
   virtual bool bIsRequestedSourceValid ( void* pArg );
   virtual bool bIsSrcSwitchRequired ( void* pArg );
   virtual bool bIsVideoSrcActive ( void* pArg );
   virtual bool bIsVideoStreamStopped ( void* pArg );
   virtual bool bIsVideoSourceConnected ( void* pArg );
   virtual bool bIsVideoStreamStarted ( void* pArg );
   virtual bool bNeedToDisconnect ( void* pArg );
   virtual bool bIsVideoSourceDisconnected ( void* pArg );

protected:
   //! currently activated video source
   dia_VideoSourceInfo mActiveVideoSource;
   //! currently activated video source
   dia_VideoSourceInfo mPreviousVideoSource;
   //! requested video source
   dia_VideoSourceInfo mRequestedVideoSource;

   //! error code information
   tDiaResult mErrorCode;

   bool mIsResultReady;
   bool mRequestedSourceValid;
   bool mIsSrcSwitchRequired;
   bool mIsVideoSrcActive;
   bool mIsVideoStreamStopped;
   bool mIsVideoSourceConnected;
   bool mIsVideoStreamStarted;
   bool mNeedToDisconnect;

   //! pointer to the FSM object
   dia_VideoSourceControlFSM::Fsm* mpFSM; //lint -sem(dia_VideoSourceControl::tearDown,cleanup)

   //! repository of remote plugins
   std::map<dia_eVideoSourceID,dia_VideoSourceControlPlugin*> mPluginRep;
   //! current plugin to be activated or deactivated
   std::map<dia_eVideoSourceID,dia_VideoSourceControlPlugin*>::iterator mPluginIter;
};

#endif /* __INCLUDED_DIA_VIDEO_SOURCE_CONTROL__ */
