/*!
 * \file       dia_VersionInfo.h
 *
 * \brief      {enter brief description here}
 *
 * \details    {enter detailed description here}
 *
 * \component  {enter component name}
 *
 * \ingroup    {enter group name}
 *
 * \copyright  (c) 2015 Robert Bosch Car Multimedia
 *
 */

#ifndef __INCLUDED_DIA_VERSION_INFO__
#define __INCLUDED_DIA_VERSION_INFO__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

namespace dia
{

class VersionInfo
{
public:
   VersionInfo ( void );
   VersionInfo ( tU16 major, tU16 minor=0, tU16 patch=0 );
   VersionInfo ( const VersionInfo& version );
   VersionInfo& operator = ( const VersionInfo& version );

   tU16 getMajorVersion ( void ) const { return mMajorVersion; }
   tU16 getMinorVersion ( void ) const { return mMinorVersion; }
   tU16 getPatchVersion ( void ) const { return mPatchVersion; }

   bool isCompatibleTo ( const VersionInfo& version ) { return ( mMajorVersion == version.mMajorVersion ) ? true : false; }

protected:
   tU16 mMajorVersion;
   tU16 mMinorVersion;
   tU16 mPatchVersion;
};

}

#endif /* __INCLUDED_DIA_VERSION_INFO__ */
