/*!
 * \file       dia_Timer.h
 *
 * \brief      Platform specific implementation of a timer resource
 *
 * \details    Platform specific implementation of a timer resource
 *
 * \component  Diagnostics
 *
 * \ingroup    diaCoreAppFrw
 *
 * \copyright  (c) 2018 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_TIMER__
#define __INCLUDED_DIA_TIMER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_LOCK__
#include <common/framework/application/dia_Lock.h>
#endif

class dia_ITimerListener;

class dia_Timer
#ifndef __DIA_UNIT_TESTING__
    : public OSAL_tclTimer
#endif
{
public:
   //! class constructor
   dia_Timer ( void );
   //! class destructor
   virtual ~dia_Timer ( void );

#ifdef __DIA_UNIT_TESTING__
   virtual tS32 s32Delete ( void ) { return OSAL_OK; }
   virtual tS32 s32Create ( void ) { return OSAL_OK; }
   virtual tS32 s32SetTime(OSAL_tMSecond , OSAL_tMSecond ) { return 0; }
#endif

   //! add a new Listener to the timer
   virtual tDiaResult addTimerListener ( dia_ITimerListener* pListener );
   //! add a new Listener to the timer
   virtual tDiaResult removeTimerListener ( const dia_ITimerListener* pListener );
   //! retrieve the unique timer ID generated from mSerial
   virtual tU32 getID ( void ) const { return mID; }

   //! callback function that is called when the timer is elapsed
   virtual void vOnAlarm ( void );

protected:
   //! unique name of the timer instance
   std::string mName;
   //! ID generator
   static tU32 mSerial;
   //! unique timer ID
   tU32 mID;
   mutable dia::Lock mSyncObj;
   //! repository of registered listeners
   std::list<dia_ITimerListener*> mListenerRep;
   //! flag to indicate whether the timer thread is already registered
   bool mIsTimerThreadRegistered;
};

// for backward compatibility
typedef tU32 dia_TimerID;

#define DIA_EN_TIMER_UNKNOWN    ((tU32) 0)

#endif /* __INCLUDED_DIA_TIMER__ */
