/*!
 * \file       dia_SocketConfiguration.h
 *
 * \brief      {enter brief description here}
 *
 * \details    {enter detailed description here}
 *
 * \component  {enter component name}
 *
 * \ingroup    {enter group name}
 *
 * \copyright  (c) 2015 Robert Bosch Car Multimedia
 *
 */

#ifndef __INCLUDED_DIA_SOCKET_CONFIGURATION__
#define __INCLUDED_DIA_SOCKET_CONFIGURATION__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#define DIA_C_U16_SOCKET_DEFAULT_MAX_MSG_SIZE            ((tU16) 4200) // max. 4096 bytes via ISOTP + header

namespace dia
{

class SocketConfiguration
{
public:
   SocketConfiguration ( void );
   SocketConfiguration ( int family, int type, int protocol );
   virtual ~SocketConfiguration ( void );

   int getFamily ( void ) const { return mFamily; }
   void setFamily ( int family ) { mFamily = family; }

   int getType ( void ) const { return mType; }
   void setType ( int type ) { mType = type; }

   int getProtocol ( void ) const { return mProtocol; }
   void setProtocol ( int protocol ) { mProtocol = protocol; }

   int getFamilyLocal ( void ) const { return mFamilyLocal; }
   void setFamilyLocal ( int family ) { mFamilyLocal = family; }

   int getFamilyServer ( void ) const { return mFamilyServer; }
   void setFamilyServer ( int family ) { mFamilyServer = family; }

   int getPortLocal ( void ) const { return mPortLocal; }
   void setPortLocal ( int port ) { mPortLocal = port; }

   int getPortServer ( void ) const { return mPortServer; }
   void setPortServer ( int port ) { mPortServer = port; }

   const std::string& getHostNameLocal ( void ) const { return mHostNameLocal; }
   void setHostNameLocal ( const std::string& name ) { mHostNameLocal = name; }

   const std::string& getHostNameServer ( void ) const { return mHostNameServer; }
   void setHostNameServer ( const std::string& name ) { mHostNameServer = name; }

   tU16 getMaxMsgSize ( void ) const { return mMaxMessageSize; }
   void setMaxMsgSize ( tU16 maxMessageSize ) { mMaxMessageSize = maxMessageSize; }

protected:
   int mFamily;
   int mType;
   int mProtocol;
   int mFamilyLocal;
   int mFamilyServer;
   int mPortLocal;
   int mPortServer;
   std::string mHostNameLocal;
   std::string mHostNameServer;
   tU16 mMaxMessageSize;
};

}

#endif /* __INCLUDED_DIA_SOCKET_CONFIGURATION__ */
