/*
 * \file        dia_SelftestControllerPlugin.h
 *
 * \brief       {insert brief description here}
 *
 * \details     {insert file description here}
 *
 * \author      kaa1hi
 * \date        Nov 27, 2014
 *
 * \copyright   Robert Bosch Car Multimedia 2014
 */

#ifndef DIA_SELFTESTCONTROLLERPLUGIN_H_
#define DIA_SELFTESTCONTROLLERPLUGIN_H_

#ifndef __INCLUDED_DIA_COMMON__
#include "common/depricated/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SELFTESTCONTROLLER__
#include "common/interfaces/dia_ISelftestController.h"
#endif

#ifndef DIA_SAFEATURESELFTESTCONTROLLERENUM_H_
#include "project/framework/sysadapters/dia_SAFeatureSelftestControllerEnum.h"
#endif


class dia_SelftestControllerPlugin
{
public:
   //! class constructor
   dia_SelftestControllerPlugin ( tCString name, dia_eSelftestControllerPluginType uId );
   //! class destructor
   virtual ~dia_SelftestControllerPlugin ( tVoid );

   //! retrieve the plugin name
   virtual tCString getName ( tVoid ) const;
   //! return the unique ID of the selftest plugin
   dia_eSelftestControllerPluginType getUID ( tVoid ) const;
   //! get status of command sending for selftest start
   virtual tDiaResult getStatusStartCommand ( void ) const;

   //! start selftest (send request to component)
   virtual tDiaResult startSelftest ( void ) = 0;

   //! force the status of the last selftest (send request to component)
   virtual tDiaResult forceSelftestResult ( void ) = 0;

   //! get last selftest status
   virtual dia_eSelftestControllerResultType getSelftestResult (void) const;

   //! set selftest status
   virtual void setSelftestResult (dia_eSelftestControllerResultType status);

protected:
   //! class constructor
   dia_SelftestControllerPlugin ( tVoid );

   //! update the selftest result of this plugin
   virtual tVoid vOnSelftestControllerUpdate ( dia_eSelftestControllerResultType selftestResult );

protected:
   //! status of command sending for selftest start
   tDiaResult mStartStatus;

   //! name of the service handler
   tCString const mSelftestControllerPluginName;
   //! unique id of the selftest plugin
   const dia_eSelftestControllerPluginType mUID;
   //! status of selftest procedure
   dia_eSelftestControllerResultType mSelftestStatus;
};

#endif /* DIA_SELFTESTCONTROLLERPLUGIN_H_ */
