/*
 * \file        dia_SelftestControllerPlugin.cpp
 *
 * \brief       {insert brief description here}
 *
 * \details     {insert file description here}
 *
 * \author      kaa1hi
 * \date        Nov 27, 2014
 *
 * \copyright   Robert Bosch Car Multimedia 2014
 */


#ifndef __INCLUDED_DIA_COMMON__
#include "../../depricated/dia_common.h"
#endif

#ifndef DIA_SELFTESTCONTROLLER_H_
#include "common/framework/application/dia_SelftestController.h"
#endif

#ifndef DIA_SELFTESTCONTROLLERPLUGIN_H_
#include "common/framework/application/dia_SelftestControllerPlugin.h"
#endif


extern const char* ResultTypeToTxt[DIA_EN_SELFTESTCONTROLLER_RESULT_TYPE_COUNT];

//-----------------------------------------------------------------------------

dia_SelftestControllerPlugin::dia_SelftestControllerPlugin (
      tCString name,
      dia_eSelftestControllerPluginType id
   )
   : mStartStatus(DIA_FAILED),
     mSelftestControllerPluginName(name),
     mUID(id),
     mSelftestStatus(DIA_EN_SELFTESTCONTROLLER_RESULT_TYPE_UNKNOWN)
{
}

//-----------------------------------------------------------------------------

dia_SelftestControllerPlugin::~dia_SelftestControllerPlugin ( tVoid )
{
}

//-----------------------------------------------------------------------------

tCString
dia_SelftestControllerPlugin::getName ( tVoid ) const
{
   return mSelftestControllerPluginName;
}

//-----------------------------------------------------------------------------

dia_eSelftestControllerPluginType
dia_SelftestControllerPlugin::getUID ( tVoid ) const
{
   return mUID;
}

tDiaResult
dia_SelftestControllerPlugin::getStatusStartCommand ( void ) const
{
   return mStartStatus;
}

//-----------------------------------------------------------------------------

dia_eSelftestControllerResultType
dia_SelftestControllerPlugin::getSelftestResult (void) const
{
   return mSelftestStatus;
}

//-----------------------------------------------------------------------------

void
dia_SelftestControllerPlugin::setSelftestResult (dia_eSelftestControllerResultType newSelftestStatus)
{
   dia_tclFnctTrace oTrace("dia_SelftestControllerPlugin::setSelftestResult()");

   DIA_TR_INF("mSelftestStatus changed: old %s; new %s", ResultTypeToTxt[mSelftestStatus], ResultTypeToTxt[newSelftestStatus]);

   mSelftestStatus = newSelftestStatus;
}


//-----------------------------------------------------------------------------

tVoid
dia_SelftestControllerPlugin::vOnSelftestControllerUpdate ( dia_eSelftestControllerResultType selftestResult )
{
   dia_tclFnctTrace oTrace("dia_SelftestControllerPlugin::vOnSelftestControllerUpdate()");

   setSelftestResult(selftestResult);
   dia_SelftestController::getInstance()->vOnSelftestControllerPluginUpdate(*this);
}
