/*
 * dia_QueueImpl.h
 *
 *  Created on: 27.11.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_QUEUE_IMPL__
#define __INCLUDED_DIA_QUEUE_IMPL__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_LOCK__
#include "common/framework/application/dia_Lock.h"
#endif

#ifndef __INCLUDED_DIA_LOCK_SCOPE__
#include "common/framework/application/dia_LockScope.h"
#endif

#ifndef __INCLUDED_DIA_CONDVAR__
#include "common/framework/application/dia_CondVar.h"
#endif

#ifndef VARIANT_S_FTR_ENABLE_QUEUE_AS_OSAL_QUEUE
#include <list>
#endif


#ifdef VARIANT_S_FTR_ENABLE_QUEUE_AS_OSAL_QUEUE
#define DIA_C_U32_QUEUE_IMPL_TIMEOUT_DISABLED OSAL_C_TIMEOUT_FOREVER
#else
#define DIA_C_U32_QUEUE_IMPL_TIMEOUT_DISABLED ((tU32) 0xFFFFFFFF)
#endif

#ifndef VARIANT_S_FTR_ENABLE_QUEUE_AS_OSAL_QUEUE
#define DIA_C_QUEUE_CONDVAR_SIGNAL_QUEUE_NOT_EMPTY       DIA_C_CONDVAR_EVENT_01
#define DIA_C_QUEUE_CONDVAR_NAME_EXTENSION               "_CV"
#define DIA_C_QUEUE_LOCK_NAME_EXTENSION                  "_LK"
#endif

#ifdef VARIANT_S_FTR_ENABLE_QUEUE_AS_OSAL_QUEUE
#define DIA_C_INVALID_QUEUE_HANDLE  OSAL_C_INVALID_HANDLE
#else
#define DIA_C_INVALID_QUEUE_HANDLE  0
#endif

class dia_QueueImpl
{
public:
   dia_QueueImpl ( tCString queueName, tU16 queueSize, tU16 queueElemSize );
   virtual ~dia_QueueImpl ( void );

   virtual tDiaResult open ( void );
   virtual tDiaResult close ( void );
   template<class _T> tDiaResult addElement ( _T* pElement );
   template<class _T> tDiaResult getElement ( _T** ppElement, tU32 timeout = DIA_C_U32_QUEUE_IMPL_TIMEOUT_DISABLED );
   template<class _T> tU32 getSize ( void ) const;

protected:
   //! name of the routine
   tCString mQueueName;
   //! maximum number of elements in the queue
   tU16 mQueueSize;
   //! size of one queue element
   tU16 mQueueElementSize;
   //! unique identifier for the queue
   intptr_t mQueueHandle;

#ifndef VARIANT_S_FTR_ENABLE_QUEUE_AS_OSAL_QUEUE
   // synchronization lock object.
   dia_Lock mSyncObj;
   // synchronization condition variable
   dia_CondVar mCondVar;
   //! condition bitmask monitiored by the condition variable
   tU32 mConditionMask;
#endif
};

//-----------------------------------------------------------------------------

template<class _T>
tDiaResult
dia_QueueImpl::addElement ( _T* pElement )
{
   dia_tclFnctTrace oTrace("dia_QueueImpl::addElement()");

   tDiaResult retCode = DIA_SUCCESS;

   if ( !pElement ) return DIA_E_INVALID_POINTER;
   if ( mQueueHandle == DIA_C_INVALID_QUEUE_HANDLE ) return DIA_E_INVALID_IDENTIFIER;

   DIA_TR_INF("adding element to queue");

#ifdef VARIANT_S_FTR_ENABLE_QUEUE_AS_OSAL_QUEUE

   intptr_t ptr = (intptr_t) pElement;
   if ( OSAL_s32MessageQueuePost(mQueueHandle,(tU8*) &ptr,sizeof(_T*),OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST) != OSAL_OK )
   {
      DIA_TR_ERR("### UNABLE TO POST ELEMENT TO QUEUE. ERROR CODE (OSAL): = 0x%08x", OSAL_u32ErrorCode());
      retCode = DIA_FAILED;
   }

#else

   dia_LockScope mScopeLock(mSyncObj);

   DIA_TR_INF("dia_QueueImpl::addElement");
   std::list<_T*>* pQueue = (std::list<_T*>*) mQueueHandle;
   pQueue->push_back(pElement);
   mCondVar.signal(DIA_C_QUEUE_CONDVAR_SIGNAL_QUEUE_NOT_EMPTY,TRUE);

#endif

   return retCode;
}

//-----------------------------------------------------------------------------

template<class _T>
tDiaResult
dia_QueueImpl::getElement ( _T** ppElement, tU32 timeoutMsec )
{
   dia_tclFnctTrace oTrace("dia_QueueImpl::getElement()");

#ifdef __DIA_UNIT_TESTING__
   DIA_TR_INF("dia_QueueImpl::getElement ppElement=0x%08X, timeoutMsec %d milliseconds.", ppElement, timeoutMsec);
#endif

   if ( mQueueHandle == DIA_C_INVALID_QUEUE_HANDLE )
   {
#ifdef __DIA_UNIT_TESTING__
      DIA_TR_INF("dia_QueueImpl::getElement mQueueHandle was set to DIA_C_INVALID_QUEUE_HANDLE");
#endif
      return DIA_E_INVALID_IDENTIFIER;
   }

   if ( ppElement == 0 )
   {
#ifdef __DIA_UNIT_TESTING__
      DIA_TR_INF("dia_QueueImpl::getElement ppElement was set to 0");
#endif
      return DIA_E_INVALID_POINTER;
   }

   tDiaResult retCode;

#ifdef VARIANT_S_FTR_ENABLE_QUEUE_AS_OSAL_QUEUE

   tU32 msgPrio = OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST;
   intptr_t msgPtr  = 0;

   tS32 receivedMsgSize = OSAL_s32MessageQueueWait(mQueueHandle, (tPU8) &msgPtr, sizeof(_T*), &msgPrio, timeoutMsec );

   *ppElement = (_T*) msgPtr;

   retCode = ( (receivedMsgSize == ((tS32) sizeof(_T*))) && (*ppElement ) ) ? DIA_SUCCESS : DIA_FAILED;

#else

   retCode = mCondVar.wait(DIA_C_QUEUE_CONDVAR_SIGNAL_QUEUE_NOT_EMPTY,timeoutMsec);

   DIA_TR_INF("mCondVar.wait() returned retCode=0x%08X",retCode);

   if ( retCode == DIA_SUCCESS )
   {
      dia_LockScope mScopeLock(mSyncObj);

      std::list<_T*>* pQueue = (std::list<_T*>*) mQueueHandle;

      size_t size = pQueue->size();

      if (0 != size)
      {
         DIA_TR_INF("Size of Queue: %u", size );

         _T* pElement = pQueue->front();  //Calling front() on an empty container causes undefined behavior.

         if ( pElement )   DIA_TR_INF("Got element from queue ('%s') ...", this->mQueueName);
         *ppElement = pElement;
         pQueue->pop_front();
         DIA_TR_INF("Size of Queue: %u", pQueue->size());
         if ( pQueue->empty() )
         {
            DIA_TR_INF("mCondVar.signal(DIA_C_QUEUE_CONDVAR_SIGNAL_QUEUE_NOT_EMPTY,FALSE);");
            mCondVar.signal(DIA_C_QUEUE_CONDVAR_SIGNAL_QUEUE_NOT_EMPTY,FALSE);
         }
      }
      else
      {
         DIA_TR_INF("dia_QueueImpl::getElement Queue is empty. Returned DIA_FAILED");
         retCode = DIA_FAILED;
      }
   }
   else
   {
      DIA_TR_ERR("dia_QueueImpl::getElement mCondVar.wait failed or timeout");
   }

#endif

   DIA_TR_INF("dia_QueueImpl::getElement returned retCode = 0x%08X", retCode);

   return retCode;

}

//-----------------------------------------------------------------------------

template<class _T>
tU32
dia_QueueImpl::getSize ( void ) const
{
   dia_tclFnctTrace oTrace("dia_QueueImpl::getSize()");

   if ( mQueueHandle == DIA_C_INVALID_QUEUE_HANDLE ) return 0;

#ifdef VARIANT_S_FTR_ENABLE_QUEUE_AS_OSAL_QUEUE
   tU32 msgCount =  0;
   if ( OSAL_ERROR == OSAL_s32MessageQueueStatus(mQueueHandle, OSAL_NULL, OSAL_NULL, &msgCount) )
   {
      msgCount = 0;
   }
   return msgCount;
#else
   std::list<_T*>* pQueue = (std::list<_T*>*) mQueueHandle;
   return static_cast<tU32>(pQueue->size());
#endif
}

#endif /* __INCLUDED_DIA_QUEUE_IMPL__ */
