/*
 * dia_QueueImpl.cpp
 *
 *  Created on: 27.11.2014
 *      Author: gib2hi
 */

#include <string.h>

#ifndef __INCLUDED_DIA_QUEUE_IMPL__
#include "common/framework/application/dia_QueueImpl.h"
#endif

#ifndef __INCLUDED_DIA_LOCK_SCOPE__
#include "common/framework/application/dia_LockScope.h"
#endif

//#ifndef VARIANT_S_FTR_ENABLE_QUEUE_AS_OSAL_QUEUE
//#define DIA_C_QUEUE_CONDVAR_SIGNAL_QUEUE_NOT_EMPTY       DIA_C_CONDVAR_EVENT_01
//#define DIA_C_QUEUE_CONDVAR_NAME_EXTENSION               "_CV"
//#define DIA_C_QUEUE_LOCK_NAME_EXTENSION                  "_LK"
//#endif
//
//#ifdef VARIANT_S_FTR_ENABLE_QUEUE_AS_OSAL_QUEUE
//#define DIA_C_INVALID_QUEUE_HANDLE  OSAL_C_INVALID_HANDLE
//#else
//#define DIA_C_INVALID_QUEUE_HANDLE  0
//#endif

//-----------------------------------------------------------------------------

dia_QueueImpl::dia_QueueImpl ( tCString queueName, tU16 queueSize, tU16 queueElemSize )
   : mQueueName(queueName),
     mQueueSize(queueSize),
     mQueueElementSize(queueElemSize),
#ifdef VARIANT_S_FTR_ENABLE_QUEUE_AS_OSAL_QUEUE
     mQueueHandle(DIA_C_INVALID_QUEUE_HANDLE)
#else
     mQueueHandle(DIA_C_INVALID_QUEUE_HANDLE),
     mSyncObj(std::string(std::string(queueName) + DIA_C_QUEUE_LOCK_NAME_EXTENSION).c_str()),
     mCondVar(std::string(std::string(queueName) + DIA_C_QUEUE_CONDVAR_NAME_EXTENSION).c_str()),
     mConditionMask(DIA_C_QUEUE_CONDVAR_SIGNAL_QUEUE_NOT_EMPTY)
#endif
{
#ifdef __DIA_UNIT_TESTING__
   DIA_TR_INF("dia_QueueImpl::dia_QueueImpl(queueName=%s, queueSize=%d, queueElemSize=%d)", queueName, queueSize, queueElemSize);
#endif
}

//-----------------------------------------------------------------------------

dia_QueueImpl::~dia_QueueImpl ( void )
{
   mQueueName = 0;
////   if ( mQueueHandle != OSAL_C_INVALID_HANDLE )
//   if ( mQueueHandle != 0 )
//   {
//      (void) close();
//   }
}

//-----------------------------------------------------------------------------

tDiaResult
dia_QueueImpl::open ( void )
{
   dia_tclFnctTrace oTrace("dia_QueueImpl::open()");

#ifdef VARIANT_S_FTR_ENABLE_QUEUE_AS_OSAL_QUEUE
   tS32 retCode = OSAL_s32MessageQueueCreate(mQueueName,mQueueSize,mQueueElementSize,OSAL_EN_READWRITE,(OSAL_tMQueueHandle*)&mQueueHandle);
   if ( OSAL_OK != retCode )
   {
      DIA_TR_ERR("### UNABLE TO OPEN QUEUE (%s) ###",mQueueName);
   }
#else
   dia_LockScope mScopeLock(mSyncObj);

   // if queue was already created we can return immediately
   if ( mQueueHandle != DIA_C_INVALID_QUEUE_HANDLE ) return DIA_SUCCESS;

   mQueueHandle = (intptr_t) OSAL_NEW std::list<void*>;

   if ( mQueueHandle == 0 )
   {
      DIA_TR_ERR("### UNABLE TO OPEN QUEUE (%s) ###",mQueueName);
   }
#endif

   return ( mQueueHandle != (intptr_t)DIA_C_INVALID_QUEUE_HANDLE ) ? DIA_SUCCESS : DIA_FAILED;
}


//-----------------------------------------------------------------------------

tDiaResult
dia_QueueImpl::close ( void )
{
   dia_tclFnctTrace oTrace("dia_QueueImpl::close()");

#ifdef VARIANT_S_FTR_ENABLE_QUEUE_AS_OSAL_QUEUE
   if ( mQueueHandle == (intptr_t)DIA_C_INVALID_QUEUE_HANDLE ) return DIA_SUCCESS;

   tS32 closeResult = OSAL_s32MessageQueueClose(mQueueHandle);
   if ( OSAL_OK != closeResult )
   {
      DIA_TR_ERR("### UNABLE TO CLOSE QUEUE (%s) ###",mQueueName);
   }

   tS32 deleteResult = OSAL_s32MessageQueueDelete(mQueueName);
   if ( OSAL_OK != deleteResult )
   {
      DIA_TR_ERR("### UNABLE TO DELETE QUEUE (%s) ###",mQueueName);
   }

//      mQueueHandle = OSAL_C_INVALID_HANDLE;
//
//      if ( closeResult == OSAL_OK && deleteResult == OSAL_OK ) ? DIA_SUCCESS : DIA_FAILED;
#else
   dia_LockScope mScopeLock(mSyncObj);

   if ( mQueueHandle == 0 ) return DIA_SUCCESS;

   std::list<void*>* pQueue = (std::list<void*>*) mQueueHandle;

   if ( pQueue->size() > 0 )
   {
      DIA_TR_ERR("### DELETING NON EMPTY QUEUE %s (NUM_OF_ELEMS = %d). ELEMENTS WILL NOT BE DELETED ###",mQueueName,pQueue->size());
   }

   OSAL_DELETE pQueue;
#endif

   mQueueHandle = DIA_C_INVALID_QUEUE_HANDLE;

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

//tDiaResult
//dia_QueueImpl::addElement ( void* pElement )
//{
//   dia_tclFnctTrace oTrace("dia_QueueImpl::addElement()");
//
//   tDiaResult retCode = DIA_SUCCESS;
//
//   if ( !pElement ) return DIA_E_INVALID_POINTER;
//   if ( mQueueHandle == DIA_C_INVALID_QUEUE_HANDLE ) return DIA_E_INVALID_IDENTIFIER;
//
//#ifdef VARIANT_S_FTR_ENABLE_QUEUE_AS_OSAL_QUEUE
//
//   tU32 ptr = (tU32) pElement;
//   if ( OSAL_s32MessageQueuePost(mQueueHandle,(tU8*) pElement,sizeof(tU32),OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST) != OSAL_OK )
//   {
//      DIA_TR_ERR("### UNABLE TO POST ELEMENT TO QUEUE. ERROR CODE (OSAL): = 0x%08x", OSAL_u32ErrorCode());
//      retCode = DIA_FAILED;
//   }
//
//#else
//
//   dia_LockScope mScopeLock(mSyncObj);
//
////   printf("dia_QueueImpl::addElement: pElement=%p\n",pElement);
//   std::list<void*>* pQueue = (std::list<void*>*) mQueueHandle;
//   pQueue->push_back(pElement);
//   mCondVar.signal(DIA_C_QUEUE_CONDVAR_SIGNAL_QUEUE_NOT_EMPTY,TRUE);
//
//#endif
//
//   return retCode;
//}

//-----------------------------------------------------------------------------

//         tU32 ptr = 0;
//
//         // Wait to receiceve a message on the message que
//         receivedMsgSize = OSAL_s32MessageQueueWait (
//               hMsgQueue,
//               (tPU8) &ptr /*msgData*/ /*pEvent*/,
//               sizeof(tclEvent*),
//               &u32Prio,
//               OSAL_C_TIMEOUT_FOREVER
//         );
//
//         tclEvent* pEvent = (tclEvent*) ptr;

//tDiaResult
//dia_QueueImpl::getElement ( void** ppElement, tU32 timeout )
//{
//   dia_tclFnctTrace oTrace("dia_QueueImpl::getElement()");
//
//   if ( mQueueHandle == DIA_C_INVALID_QUEUE_HANDLE ) return DIA_E_INVALID_IDENTIFIER;
//   if ( ppElement == 0 ) return DIA_E_INVALID_POINTER;
//
//#ifdef VARIANT_S_FTR_ENABLE_QUEUE_AS_OSAL_QUEUE
//
//   tU32 msgPrio = OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST;
//   tU32 msgPtr  = 0;
//
//   tS32 receivedMsgSize = OSAL_s32MessageQueueWait(mQueueHandle, (tPU8) &msgPtr, sizeof(tU32), &msgPrio, timeout );
//
//   *ppElement = (void*) msgPtr;
//
//   DIA_TR_INF("*ppElement = 0x%p", *ppElement);
//
//   return ( (receivedMsgSize == ((tS32) sizeof(tU32))) && (*ppElement ) ) ? DIA_SUCCESS : DIA_FAILED;
//
//#else
//
//   tDiaResult retCode = mCondVar.wait(DIA_C_QUEUE_CONDVAR_SIGNAL_QUEUE_NOT_EMPTY,timeout);
////   printf("after mCondVar.wait() - retCode = 0x%08x, ppElement = %p\n",retCode,ppElement);
////   printf("after mCondVar.wait() - retCode = 0x%08x\n",retCode);
//   if ( retCode == DIA_SUCCESS )
//   {
//      dia_LockScope mScopeLock(mSyncObj);
//
//      std::list<void*>* pQueue = (std::list<void*>*) mQueueHandle;
////      printf("Size of Queue: %d\n", pQueue->size());
//      void* pElement = pQueue->front();
////      printf("Size of Queue: %d\n", pQueue->size());
////      printf("vThreadEntrypointObject: Got Element pEvent=%p\n",pElement);
//      *ppElement = pElement;
////      if ( pElement ) printf("vThreadEntrypointObject: Got Element *pEvent=%d\n",*((tU32*) pElement));
//      pQueue->pop_front();
////      printf("Size of Queue: %d\n", pQueue->size());
//      if ( pQueue->empty() )
//      {
////         printf("mCondVar.signal(DIA_C_QUEUE_CONDVAR_SIGNAL_QUEUE_NOT_EMPTY,FALSE);\n");
//         mCondVar.signal(DIA_C_QUEUE_CONDVAR_SIGNAL_QUEUE_NOT_EMPTY,FALSE);
//      }
//   }
//
////   printf("Got Element ...\n");
//   return DIA_SUCCESS;
//#endif
//}

