/**
 * \file      dia_PredicateAppState.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      Sep 30, 2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_PREDICATE_APPSTATE__
#include <common/framework/application/dia_PredicateAppState.h>
#endif

#ifndef __INCLUDED_DIA_APPCONTROLLER__
#include <common/framework/application/dia_AppController.h>
#endif

using namespace dia;

//-----------------------------------------------------------------------------

dia_PredicateAppState::dia_PredicateAppState ( bool appState )
   : dia_Predicate(dia_PredicateAppState::getClassIdentifier()),
     isAppStateChanging(appState)
{
   mUID = mClassID;
}

//-----------------------------------------------------------------------------

dia_PredicateAppState::dia_PredicateAppState ( const dia_PredicateAppState& obj )
   : dia_Predicate(obj),
     isAppStateChanging(obj.isAppStateChanging)
{}

//-----------------------------------------------------------------------------

dia_PredicateAppState&
dia_PredicateAppState::operator = ( const dia_PredicateAppState& obj )
{
   if ( this != &obj )
   {
      mUID       = obj.mUID;
      mClassID   = obj.mClassID;
      mIsMatched = obj.mIsMatched;
      isAppStateChanging  = obj.isAppStateChanging;
   }
   return *this;
}
//-----------------------------------------------------------------------------

dia_PredicateAppState::~dia_PredicateAppState ( void )
{}

//-----------------------------------------------------------------------------

dia_Predicate*
dia_PredicateAppState::clone (void )
{
   return new dia_PredicateAppState(*this);
}

//-----------------------------------------------------------------------------

tDiaResult
dia_PredicateAppState::match ( void )
{
   ScopeTrace trc("dia_PredicateAppState::match()");

   tDiaResult retCode = DIA_FAILED;

   dia_AppController* pAppCtrl = getInstanceOfAppController();
   if ( pAppCtrl )
   {
       bool isAppStCh = pAppCtrl->isApplicationStateChangeInProgress();
       DIA_TR_INF("# dia_PredicateAppState::match: isAppStCh=%d isAppStateChanging=%d", isAppStCh, isAppStateChanging );
       if ( isAppStateChanging ==  isAppStCh )
       {
           DIA_TR_INF("###################################################################");
           DIA_TR_INF("#");
           DIA_TR_INF("# dia_PredicateAppState::bMatch: app state changing %d MATCHED", isAppStateChanging? 1: 0 );
           DIA_TR_INF("#");
           DIA_TR_INF("###################################################################");
           retCode    = DIA_SUCCESS;
           mIsMatched = TRUE;
       }
   }

   return retCode;
}


//-----------------------------------------------------------------------------

void
dia_PredicateAppState::update ( const std::vector<tU32>& args )
{
   ScopeTrace trc("dia_tclPredicateRunlevel::bMatch()");

   if ( !(args.size()) ) return;
   bool newState = (args[0] == 0)? false: true;
   if (isAppStateChanging == newState)
   {
      DIA_TR_INF("###################################################################");
      DIA_TR_INF("#");
      DIA_TR_INF("# dia_PredicateAppState::update: app state changing %d MATCHED", isAppStateChanging? 1: 0 );
      DIA_TR_INF("#");
      DIA_TR_INF("###################################################################");
      mIsMatched = TRUE;
   }
}
