/**
 * \file      dia_PredicateALDStatus.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \copyright Robert Bosch Car Multimedia 2017
 */

#ifndef __INCLUDED_DIA_PREDICATE_ALDSTATUS__
#include <common/framework/application/dia_PredicateALDStatus.h>
#endif

#ifndef  __INCLUDED_DIA_INTERFACE_AUTHORIZATIONLEVEL__
#include "common/interfaces/dia_IAuthorizationLevel.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif


namespace dia
{

//-----------------------------------------------------------------------------

PredicateALDStatus::PredicateALDStatus ( void )
   : dia_Predicate(PredicateALDStatus::getClassIdentifier())
{
   std::string str = dia_composeStlString("%s",PredicateALDStatus::getClassName());
   mUID = dia_getHashCodeFromString(str);
}

//-----------------------------------------------------------------------------

PredicateALDStatus::PredicateALDStatus ( const PredicateALDStatus& obj )
   : dia_Predicate(obj)
{}

//-----------------------------------------------------------------------------

PredicateALDStatus&
PredicateALDStatus::operator = ( const PredicateALDStatus& obj )
{
   if ( this != &obj )
   {
      mUID       = obj.mUID;
      mClassID   = obj.mClassID;
      mIsMatched = obj.mIsMatched;
   }
   return *this;
}
//-----------------------------------------------------------------------------

PredicateALDStatus::~PredicateALDStatus ( void )
{}

//-----------------------------------------------------------------------------

dia_Predicate*
PredicateALDStatus::clone (void )
{
   return new PredicateALDStatus(*this);
}

//-----------------------------------------------------------------------------

tDiaResult
PredicateALDStatus::match ( void )
{
   ScopeTrace trc("dia::PredicateALDStatus::match()");

   tDiaResult retCode = DIA_FAILED;

   // retrieve ALD level
   dia_IAuthorizationLevel* pAuthLevel = 0;
   if ( (querySysAdapterInterface<dia_IAuthorizationLevel>(&pAuthLevel) == DIA_SUCCESS) && (NULL!=pAuthLevel) )
   {
      if ( pAuthLevel->getCurrentLevel() != DIA_C_U16_ALD_UNKNOWN_LEVEL )
      {
         DIA_TR_INF("###################################################################");
         DIA_TR_INF("#");
         DIA_TR_INF("# PredicateALDStatus::MATCHED (ALD STATUS KNOWN 0x%04X)", pAuthLevel->getCurrentLevel());
         DIA_TR_INF("#");
         DIA_TR_INF("###################################################################");
         retCode    = DIA_SUCCESS;
         mIsMatched = TRUE;
      }
   }

   return retCode;
}


//-----------------------------------------------------------------------------

void
PredicateALDStatus::update ( const std::vector<tU32>& args )
{
   ScopeTrace trc("dia::PredicateALDStatus::update()");

   if ( !(args.size()) ) return;

   if ( args[0] != DIA_C_U16_ALD_UNKNOWN_LEVEL )
   {
      DIA_TR_INF("###################################################################");
      DIA_TR_INF("#");
      DIA_TR_INF("# PredicateALDStatus::UPDATE (ALD STATUS KNOWN 0x%04X)", args[0]);
      DIA_TR_INF("#");
      DIA_TR_INF("###################################################################");
      mIsMatched = TRUE;
   }
}

}
