/**
 * \file      dia_Predicate.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      Sep 27, 2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_PREDICATE__
#define __INCLUDED_DIA_PREDICATE__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

//-----------------------------------------------------------------------------

class dia_Predicate
{
//   friend class dia::Command;

protected:
   //! class constructor (can only be used by subclasses)
   dia_Predicate ( dia_CLASSID cid, tCString name );
   //! class constructor (can only be used by subclasses)
   dia_Predicate ( dia_CLASSID cid, dia_UID uid );
   //! class constructor (can only be used by subclasses)
   dia_Predicate ( dia_CLASSID cid );
   //! deprecated default class constructor
   dia_Predicate ( void );
   //! copy constructor
   dia_Predicate ( const dia_Predicate& obj );
   //! assignment operator
   dia_Predicate& operator = ( const dia_Predicate& obj );

public:
   //! destructor
   virtual ~dia_Predicate ( void );

   //! return the identifier
   dia_UID getUID ( void ) const { return mUID; }
   //! return the class identifier
   dia_CLASSID getClassID ( void ) const { return mClassID; }
   //! check if the predicate is matched
   virtual tDiaResult match ( void ) = 0;
   //! check preconditions (return true if preconditions are fulfilled)
   virtual bool checkPreConditions(void){ return true; }

   //! check if the predicate is marked as matched
   virtual tBool isMatched ( void ) const { return mIsMatched; }

   //! observer pattern
   virtual void update ( const std::vector<tU32>& args ) = 0;
   //! prototype pattern
   virtual dia_Predicate* clone (void ) = 0;

protected:
   void setUID ( dia_UID uid ) { mUID = uid; }

protected:
   //! unique identifier for this predicate
   dia_UID mUID;
   //! identifier that identifies the class of predicates this object belongs to
   dia_CLASSID mClassID;
   //! flag to indicate if the predicate is matched
   tBool mIsMatched;
};

#define DIA_DECL_PREDICATE_CLASS(classid) \
public: \
   static dia_CLASSID getClassIdentifier ( void ) { return dia_getHashCodeFromString(classid); } \
   static const char* getClassName ( void ) { return classid; }

#endif /* __INCLUDED_DIA_PREDICATE__ */
