/*
 * \file        dia_ObjectWithUID.h
 *
 * \brief       Foundation class for objects having a name, that is used to
 *              calculate a unique ID of the name using a hashcode
 *
 * \details     None
 *
 * \copyright   Robert Bosch Car Multimedia 2015
 *
 */

#ifndef __INCLUDED_DIA_OBJECT_WITH_UID__
#define __INCLUDED_DIA_OBJECT_WITH_UID__

#ifndef __INCLUDED_DIA_OBJECT__
#include <common/framework/application/dia_Object.h>
#endif

/**
 * \class   dia_ObjectWithUID
 *
 * \brief   Foundation class for objects having a name, that is used to
 *          calculate a unique ID of the name using a hashcode
 *
 * \ingroup diaCoreAppFrw
 */

namespace dia {

class ObjectWithUID
   : public virtual dia_Object
{
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(ObjectWithUID);

public:
   //! class constructor
   ObjectWithUID ( tCString name );
   //! class constructor
   ObjectWithUID ( const std::string& name );
   //! class destructor
   virtual ~ObjectWithUID ( void );

   //! retrieve the objects name
   tCString getName ( void ) const { return mName.c_str(); }
   //! return the type of the signal
   UID getUID ( void ) const { return mUID; }

protected:
    //! default class constructor without implemen
   ObjectWithUID ( void );

protected:
    //! name of the object
    std::string mName;
    //! unique ID of the object (hashcode calculated from name)
    UID mUID;
};

}

typedef dia::ObjectWithUID dia_ObjectWithUID;

#endif /* __INCLUDED_DIA_OBJECT_WITH_UID__ */
