/*
 * dia_Notifier.cpp
 *
 *  Created on: 02.06.2016
 *      Author: gib2hi
 */

/*!
 * \file       dia_Notifier.cpp
 *
 * \brief      Template class used to broadcast notification to a defined set of listeners
 *
 * \details    Template class used to broadcast notification to a defined set of listeners
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreAppFrw
 *
 * \copyright  (c) 2011-2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#include "dia_Notifier.h"

namespace dia {

//-----------------------------------------------------------------------------

NotifierBase::NotifierBase ( void )
{}

//-----------------------------------------------------------------------------

NotifierBase::~NotifierBase ( void )
{}

//-----------------------------------------------------------------------------

void
NotifierBase::clear ( void )
{
   mListenerRep.clear();
}

//-----------------------------------------------------------------------------

tDiaResult
NotifierBase::attachListener ( void* pListener )
{
#ifdef __DIA_UNIT_TESTING__
   dia_tclFnctTrace oTrace("dia::NotifierBase::attachListener()");
#endif

   if ( !pListener ) return DIA_E_INVALID_POINTER;

   std::list<void*>::iterator it = std::find(mListenerRep.begin(),mListenerRep.end(),pListener);
   if ( it == mListenerRep.end() )
   {
      mListenerRep.push_back(pListener);
      return DIA_SUCCESS;
   }

   return DIA_E_ALREADY_EXISTS;
}

//-----------------------------------------------------------------------------

tDiaResult
NotifierBase::detachListener ( void* pListener )
{
#ifdef __DIA_UNIT_TESTING__
   dia_tclFnctTrace oTrace("dia::Notifier::detachListener()");
#endif

   if ( !pListener ) return DIA_E_INVALID_POINTER;

   std::list<void*>::iterator it = std::find(mListenerRep.begin(),mListenerRep.end(),pListener);
   if ( it != mListenerRep.end() )
   {
      mListenerRep.erase(it);
      return DIA_SUCCESS;
   }

   return DIA_E_NOT_FOUND;
}

//-----------------------------------------------------------------------------

void
NotifierBase::mergeListeners ( const dia::NotifierBase& notifier )
{
#ifdef __DIA_UNIT_TESTING__
   dia_tclFnctTrace oTrace("dia::Notifier::mergeListeners(const dia::NotifierBase&)");
#endif

   const std::list<void*>& listeners = notifier.getListeners();
   for ( std::list<void*>::const_iterator it1 = listeners.begin(); it1 != listeners.end(); ++it1 )
   {
      if ( !(*it1) ) continue;

      std::list<void*>::iterator it2 = std::find(mListenerRep.begin(),mListenerRep.end(),*it1);
      if ( it2 == mListenerRep.end() )
      {
         mListenerRep.push_back((*it1));
      }
   }
}

//-----------------------------------------------------------------------------

const std::list<void*>&
NotifierBase::getListeners ( void ) const
{
   return mListenerRep;
}

}

