/*!
 * \file       dia_LockScope.h
 *
 * \brief      Locking class used for scoped locking in multiple thread environments
 *
 * \details    Locking class used for scoped locking in multiple thread environments
 *
 * \component  Diagnostics
 *
 * \ingroup    diaCoreAppFrw
 *
 * \copyright  (c) 2012-2017 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_LOCK_SCOPE__
#define __INCLUDED_DIA_LOCK_SCOPE__

namespace dia {

class Lock;

class LockScope
{
public:
   //! class constructor, automatically locks the given mutex
   LockScope ( Lock& rLock );
   //! class destructor, automatically unlocks the mutex
   virtual ~LockScope ( void );

protected:
   //! deprecated default constructor (no implementation)
   LockScope ( void );
   //! deprecated copy constructor (no implementation)
   LockScope ( const LockScope& );
   //! deprecated assignment operator (no implementation)
   LockScope& operator = ( const LockScope& );

   //! reference to the mutex we are locking/unlocking automatically
   Lock& mLock;  //lint !e1725: a reference to a lock object is intended here. copy construction and assignment for this class are blocked.
};

}

#define dia_LockScope dia::LockScope

#endif /* __INCLUDED_DIA_LOCK_SCOPE__ */
