/*!
 * \file       dia_Lock.h
 *
 * \brief      Locking class used for synchronized access in multiple thread environments
 *
 * \details    Locking class used for synchronized access in multiple thread environments
 *
 * \component  Diagnostics
 *
 * \ingroup    diaCoreAppFrw
 *
 * \copyright  (c) 2012-2017 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_LOCK__
#define __INCLUDED_DIA_LOCK__

//lint -e831  Info:    reference cited in prior message

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifdef VARIANT_S_FTR_ENABLE_LOCK_AS_PTHREAD_MUTEX
#include <unistd.h>
#include <pthread.h>
#endif

#define DIA_C_LOCK_TIMEOUT_FOREVER     ((tU32) 0xFFFFFFFF)

namespace dia {

class Lock
{
public:
   //! class constructor
   Lock ( const char* name );
   //! class constructor
   Lock ( const std::string& name );
   //! class destructor
   virtual ~Lock ( void );

   //! lock the synchronization object
   tDiaResult lock ( void );
   //! lock the synchronization object
   tDiaResult lock ( tU32 timeout );
   //! unlock the synchronization object
   tDiaResult unlock ( void );

protected:
   //! deprecated default constructor (no implementation)
   Lock();
   //! deprecated copy constructor (no implementation)
   Lock( const Lock& );
   //! deprecated assignment operator (no implementation)
   Lock& operator = ( const Lock& );

   //! name of the lock object
   std::string  mName;

#ifdef VARIANT_S_FTR_ENABLE_LOCK_AS_PTHREAD_MUTEX
   pthread_mutexattr_t  mAttr;
   pthread_mutex_t      mMutex;
#else
   //! handle of the lock object
   OSAL_tSemHandle mHandle;
#endif
};

}

#define dia_Lock dia::Lock

#endif
