/*
 * dia_InitializationLevel.cpp
 *
 *  Created on: 01.09.2017
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_INITIALIZATION_LEVEL__
#include <common/framework/application/dia_InitializationLevel.h>
#endif

namespace dia {

std::list<InitializationLevel*> InitializationLevel::mLevelSequence;

//---------------------------------------------------------------------------------------------------------------------

struct InitLevelComparator
{
   InitLevelComparator ( InitializationLevel& level ) : mLevelName(level.getName()) {}
   InitLevelComparator ( const InitializationLevel& level ) : mLevelName(level.getName()) {}
   bool operator() ( const InitializationLevel* pLevel ) const { return (pLevel && (mLevelName == pLevel->getName())) ? true : false; }

protected:
   InitLevelComparator ( void );

private:
   std::string mLevelName;
};

//-----------------------------------------------------------------------------

InitializationLevel::InitializationLevel ( std::string& levelName, dia_enInitLevel levelID )
   : ObjectWithUID(levelName),
     mLevelID(levelID)
{
}

//-----------------------------------------------------------------------------

InitializationLevel::InitializationLevel ( const char* levelName, dia_enInitLevel levelID )
   : ObjectWithUID(levelName),
     mLevelID(levelID)
{
}

//-----------------------------------------------------------------------------

InitializationLevel::~InitializationLevel ( void )
{
}

//------------------------------------------------------------------------------

bool
InitializationLevel::equal ( const InitializationLevel& level )
{
   std::list<InitializationLevel*>::iterator iter1 = std::find_if(mLevelSequence.begin(),mLevelSequence.end(),InitLevelComparator(*this));
   std::list<InitializationLevel*>::iterator iter2 = std::find_if(mLevelSequence.begin(),mLevelSequence.end(),InitLevelComparator(level));
   if ( iter1 == mLevelSequence.end() || iter2 == mLevelSequence.end() )
   {
      // at least one of the levels is not a member of the initialization list
      return false;
   }

   return ( std::distance(mLevelSequence.begin(), iter2) == std::distance(mLevelSequence.begin(), iter1) ) ? true : false;
}

//------------------------------------------------------------------------------

bool
InitializationLevel::less ( const InitializationLevel& level )
{
   std::list<InitializationLevel*>::iterator iter1 = std::find_if(mLevelSequence.begin(),mLevelSequence.end(),InitLevelComparator(*this));
   std::list<InitializationLevel*>::iterator iter2 = std::find_if(mLevelSequence.begin(),mLevelSequence.end(),InitLevelComparator(level));
   if ( iter1 == mLevelSequence.end() || iter2 == mLevelSequence.end() )
   {
      // at least one of the levels is not a member of the initialization list
      return false;
   }

   return ( std::distance(mLevelSequence.begin(), iter1) < std::distance(mLevelSequence.begin(), iter2) ) ? true : false;
}

//------------------------------------------------------------------------------

bool
InitializationLevel::operator == ( const InitializationLevel& level )
{
    return equal(level);
}

//------------------------------------------------------------------------------

bool
InitializationLevel::operator != ( const InitializationLevel& level )
{
    return !(equal(level));
}

//------------------------------------------------------------------------------

bool
InitializationLevel::operator <  ( const InitializationLevel& level )
{
    return less(level);
}

//------------------------------------------------------------------------------

bool
InitializationLevel::operator >  ( const InitializationLevel& level )
{
   return const_cast<InitializationLevel&>(level).less(*this);
}

//------------------------------------------------------------------------------

bool
InitializationLevel::operator <= ( const InitializationLevel& level )
{
    return (less(level) || equal(level));
}

//------------------------------------------------------------------------------

bool
InitializationLevel::operator >= ( const InitializationLevel& level )
{
   return (const_cast<InitializationLevel&>(level).less(*this) || const_cast<InitializationLevel&>(level).equal(*this)) ? true : false;
}

//-----------------------------------------------------------------------------

tDiaResult
InitializationLevel::addInitializationLevel ( InitializationLevel& level )
{
   ScopeTrace oTrace("dia::InitializationLevel::addInitializationLevel(InitializationLevel&)");

   tDiaResult retCode = DIA_FAILED;

   std::list<InitializationLevel*>::iterator iter = std::find_if(mLevelSequence.begin(),mLevelSequence.end(),InitLevelComparator(level));
   if ( iter == mLevelSequence.end() )
   {
      DIA_TR_INF("ADDING INITIAL LEVEL \"%s\" (UID=0x%08x) TO INITIAL LEVEL SQUENCE", level.getName(),level.getUID());
      mLevelSequence.push_back(&level);
      retCode = DIA_SUCCESS;
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
InitializationLevel::addInitializationLevel ( InitializationLevel* pLevel )
{
   ScopeTrace oTrace("dia::InitializationLevel::addInitializationLevel(InitializationLevel*)");

   if ( !pLevel ) return DIA_E_INVALID_POINTER;
   return addInitializationLevel(*pLevel);
}

//-----------------------------------------------------------------------------

void
InitializationLevel::clearInitializationLevels ( void )
{
   ScopeTrace oTrace("dia::InitializationLevel::clearInitializationLevels()");

   DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(InitializationLevel,mLevelSequence)
}

}
