/*
 * dia_FileDir.h
 *
 *  Created on: 21.01.2015
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_FILE_DIR__
#define __INCLUDED_DIA_FILE_DIR__

#include <common/framework/application/dia_common.h>

enum dia_enFilePermission
{
   DIA_EN_FILE_PERMISSION_UNKNWON = 0,
   DIA_EN_FILE_PERMISSION_READ_ONLY,
   DIA_EN_FILE_PERMISSION_READ_AND_WRITE,
   DIA_EN_FILE_PERMISSION_WRITE_ONLY,
   DIA_EN_FILE_PERMISSION_COUNT
};

class dia_FileDir
{
public:
   dia_FileDir ( const std::string& name, dia_enFilePermission permission = DIA_EN_FILE_PERMISSION_READ_AND_WRITE );
   dia_FileDir ( tCString name, dia_enFilePermission permission = DIA_EN_FILE_PERMISSION_READ_AND_WRITE );
   virtual ~dia_FileDir ( void );

   //! create the directory with the given pathname and the given permissions
   virtual tDiaResult create ( void );
   //! delete the directory with all contained files
   //virtual tDiaResult remove  ( void ) { return DIA_E_NOT_IMPLEMENTED; }
   virtual tDiaResult remove  ( void );
   //! check if a directory with the given pathname already exists
   virtual bool doesExist ( void ) const;

protected:
   dia_FileDir ( void );

protected:
   //! name of the directory (full path name)
   std::string mDirName;
   //! permissions for this directory
   dia_enFilePermission mPermissions;
};

#endif /* __INCLUDED_DIA_FILE_DIR__ */
