/*
 * dia_FileDir.cpp
 *
 *  Created on: 21.01.2015
 *      Author: gib2hi
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fstream>     //lint !e537 : repeatedly included header file without standard include guard
#include <stdlib.h>    //lint !e537 !e451 : repeatedly included header file without standard include guard
#include <sys/wait.h>  //lint !e537 : repeatedly included header file without standard include guard

#ifndef __INCLUDED_DIA_FILE_DIR__
#include <common/framework/application/dia_FileDir.h>
#endif

//-----------------------------------------------------------------------------

dia_FileDir::dia_FileDir ( const std::string& name, dia_enFilePermission permissions )
   : mDirName(name), mPermissions(permissions)
{}

//-----------------------------------------------------------------------------

dia_FileDir::dia_FileDir ( tCString name, dia_enFilePermission permissions )
   : mDirName(name), mPermissions(permissions)
{}

//-----------------------------------------------------------------------------

dia_FileDir::~dia_FileDir ( void )
{
//   mDirName = 0;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FileDir::create ( void )
{
   dia_tclFnctTrace trc("dia_FileDir::create()");

   tDiaResult retCode = DIA_SUCCESS;

   if ( !doesExist() )
   {
      // @TODO: set permissions according to the mPermissions attribute
      if ( mkdir(mDirName.c_str(), S_IRWXU | S_IRWXG | S_IRWXO) != 0 )
      {
         DIA_TR_ERR("##### CREATION OF DIRECTORY \"%s\" FAILED !! #####", mDirName.c_str());
         retCode = DIA_FAILED;
      }
   }

   return retCode;
}

tDiaResult
dia_FileDir::remove ( void )
{
   dia_tclFnctTrace trc("dia_FileDir::remove()");

   tDiaResult retCode = DIA_SUCCESS;

   if ( doesExist() )
   {
      DIA_TR_INF("Directory \"%s\" exists. Deleting now...", mDirName.c_str());
      // Construct the system command to delete the 
      // existing directory & its contents
      std::string cmd_rmdir = "rm -rf " + mDirName;
      // Execute system command to delete the directory & its contents
      int ret = system(cmd_rmdir.c_str());
      // Evaluate the system command execution result
      if ( WIFSIGNALED(ret) && ((WTERMSIG(ret) == SIGINT) || (WTERMSIG(ret) == SIGQUIT)) )
      {
         DIA_TR_ERR("  +--> SYSTEM COMMAND EXECUTION FAILED FOR rmdir \"%s\"!!!", mDirName.c_str());
         retCode = DIA_FAILED;
      }
   }

   return retCode;
}

bool
dia_FileDir::doesExist ( void ) const
{
   dia_tclFnctTrace trc("dia_FileDir::doesExist()");

   bool retCode = false;

   struct stat sb;
   if ( (stat(mDirName.c_str(), &sb) == 0) && S_ISDIR(sb.st_mode) ) retCode = true;

   return retCode;
}
