/**
 * \file      dia_File.h
 *
 * \brief     File operations: open, close, read, write
 *
 * \details   { File operations }
 *
 * \author    bhs1hi, gib2hi, kaa1hi
 * \date      Jan 25, 2015
 *
 * \copyright Robert Bosch Car Multimedia 2015
 */

#ifndef __INCLUDED_DIA_FILE__
#define __INCLUDED_DIA_FILE__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

using namespace std;

typedef unsigned short dia_FileMode;

#define  DIA_C_FILE_MODE_USER_RWX         ((dia_FileMode) 0000700) /* RWX mask for owner */
#define  DIA_C_FILE_MODE_USER_RW          ((dia_FileMode) 0000600) /* RW  mask for owner */
#define  DIA_C_FILE_MODE_USER_R           ((dia_FileMode) 0000400) /* R for owner */
#define  DIA_C_FILE_MODE_USER_W           ((dia_FileMode) 0000200) /* W for owner */
#define  DIA_C_FILE_MODE_USER_X           ((dia_FileMode) 0000100) /* X for owner */

#define  DIA_C_FILE_MODE_GROUP_RWX        ((dia_FileMode) 0000070) /* RWX mask for group */
#define  DIA_C_FILE_MODE_GROUP_RW         ((dia_FileMode) 0000060) /* RW  mask for group */
#define  DIA_C_FILE_MODE_GROUP_R          ((dia_FileMode) 0000040) /* R for group */
#define  DIA_C_FILE_MODE_GROUP_W          ((dia_FileMode) 0000020) /* W for group */
#define  DIA_C_FILE_MODE_GROUP_X          ((dia_FileMode) 0000010) /* X for group */

#define  DIA_C_FILE_MODE_OTHER_RWX        ((dia_FileMode) 0000007) /* RWX mask for other */
#define  DIA_C_FILE_MODE_OTHER_R          ((dia_FileMode) 0000004) /* R for other */
#define  DIA_C_FILE_MODE_OTHER_W          ((dia_FileMode) 0000002) /* W for other */
#define  DIA_C_FILE_MODE_OTHER_X          ((dia_FileMode) 0000001) /* X for other */

class dia_File
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_File);

public:
   //! class constructor. expects file name with full path
   dia_File ( tCString fileWithPath );
   //! class constructor. expects file name with full path
   dia_File ( const std::string& fileWithPath );
   //! class destructor
   virtual ~dia_File ( void );

   //! File exists?
   virtual bool doesExist ( void ) const;
   //! File open operation
   virtual tDiaResult open ( tCString options );
   //! File close operation
   virtual tDiaResult close ( void  );
   //! File create operation
   virtual tDiaResult create ( void ) { return DIA_E_NOT_IMPLEMENTED; }
   //! File delete operation
   virtual tDiaResult remove ( void );
   //! Get file name
   virtual const char* getFileName ( void ) const { return mFileName.c_str(); }
   //! File getline operation
   virtual tDiaResult getLine ( std::string& line);
   //! File getline operation
   virtual tDiaResult getLine ( tChar *line,  tS32 buffSize, tU32 *lenReadStr);
   //! File writeline operation
   virtual tDiaResult writeLine ( tChar *line,  tU32 u32LineSize);
   //! File getline operation
   virtual tDiaResult rawRead( tU8* data,  size_t* dataLength );
   //! File writeline operation
   virtual tDiaResult rawWrite ( tU8* data, size_t* dataLength );
   //! File eof operation
   virtual bool endOfFile ( void );
   //! set group ID
   virtual tDiaResult setGroupByID ( tU32 groupID );
   //! set group ID via group name
   virtual tDiaResult setGroupByName ( tCString groupName );
   //! set group ID via group name
   virtual tDiaResult changeMode ( dia_FileMode mode );
   //! get size of file in bytes
   virtual tU32 getSize(void);

protected:
   //! default class constructor
   dia_File ( void );

protected:
   //! file name (including path information)
   std::string mFileName;
   //! file descriptor
   FILE* mFd;
};

#endif /* __INCLUDED_DIA_FILE__ */
