/************************************************************************
* FILE:         dia_EventThread.h
* PROJECT:      Fc_Diagnosis
* SW-COMPONENT: Diagnostic application
*----------------------------------------------------------------------
*
* DESCRIPTION: Class to starts the fc_diagnosis multi-purpose event waiting thread
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2004 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 02.03.15  | NBS3KOR            | initial version
*
*************************************************************************/

#ifndef __INCLUDED_DIA_EVENT_THREAD__
#define __INCLUDED_DIA_EVENT_THREAD__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

/*
#ifndef __INCLUDED_DIA_DIAGSESSION__
#include "common/depricated/dia_tclDiagSession.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_RUNLEVEL_LISTENER__
#include <common/interfaces/dia_IRunLevelListener.h>
#endif
*/

#ifndef __INCLUDE_DIA_ACTIVE_OBJECT__
#include <common/framework/application/dia_ActiveObject.h>
#endif

#ifndef __INCLUDED_DIA_QUEUE__
#include "common/framework/application/dia_Queue.h"
#endif

extern dia_EventThread* getInstanceOfdiaEventThread ( void );
extern void releaseInstanceOfdiaEventThread ( void );

class dia_EventThread
    : public dia_ActiveObject
{
//   friend class dia_tclDiagSessionBodyUds;
   friend class dia_Application;

   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_EventThread);

public:
    // Prototype for the service handler
//    virtual void vLookupSrvcHandler();
//    // msg buffer accessors
//    virtual dia_MessageBufferUDS& oDiagMsgBuffer() const;
//
//    dia_MessageBufferUDS *poUdsMsgBuffer(); // const;
//
//    // null response (fabricates a confirmation without sending the response to the tester)
//    static void vNullResponse(const tU8*, tU16);
//
//    virtual void vEmit( tclEvent* pEvent ) const;
   static OSAL_tEventHandle m_hEvent;

   virtual tBool bPostEvent ( tU32 u32Event ) const;

protected:
    // Constructor
    dia_EventThread ( void );
    // Destructor
    virtual ~dia_EventThread ( void );

#ifdef __DIA_UNIT_TESTING__
public:
#endif
    //! setup method for the application
    tDiaResult setup ( void );

    //! shutdown method for the application
    tDiaResult tearDown ( void );

#ifdef __DIA_UNIT_TESTING__
protected:
#endif
    //! overloaded method from dia_IRunLevelListener
//    virtual tVoid vOnRunLevelChanged ( dia_enRunlevel newLevel, dia_enRunlevel oldLevel );

protected:
//    // worker thread for diag sessions
//    static void vDiagSessionThread(void*);
    //! object specific thread function
    virtual void vThreadEntrypointObject ( void );

    //! pointer to the FSM object
//    dia_tclDiagSessionBodyUds* mpBody;

   //! queue used by the objects thread to store incoming messages
   // dia_Queue<tclEvent>* mpMsgQueue;

    // name of msg queue of worker thread
   // static tCString strQueueName;
    static tCString strThreadName;

};


#endif
