/**
 * \file      dia_EventLogger.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    kaa1hi
 * \date      Mar 7, 2014
 *
 * \copyright Robert Bosch Car Multimedia 2014
 */


#ifndef __INCLUDED_DIA_EVENT_LOGGER__
#define __INCLUDED_DIA_EVENT_LOGGER__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_EVENT_LOG__
#include "common/framework/application/dia_EventLog.h"
#endif

#define DIA_EVENT_LOGGER_LIST_LIMIT ((tU32)(100*1000))

#define DIA_EVENTLOGGER(errCode16bit)  { dia_EventLogger* p=getInstanceOfEventLogger(); if(NULL!=p){p->addEvent( (errCode16bit), __FILE__, (__LINE__) );} }
#define DIA_EVENTLOGGER_LINE(errCode16bit,line)  { dia_EventLogger* p=getInstanceOfEventLogger(); if(NULL!=p){p->addEvent( (errCode16bit), __FILE__, ((tU32)line) );} }


class dia_EventLogger
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_EventLogger);

public:
   //! return number of events in the list
   virtual tU16 numberOfEvents ( void ) const;
   //! push an event to the front of the list
   virtual void addEvent(tU16 errCode, const char* filename, const tS8* lineNumberStr);
   //! push an event to the front of the list
   virtual void addEvent(tU16 errCode, const char* filename, tU32 lineNumber32bit);
   //! Dump requested number of events
   virtual void DumpEvents(tU32 reqNumberItems);
   //! set maximal size of list
   virtual void SetMaxSizeOfList(size_t newSize);
   //! get error code of specified event
   virtual tU16 GetErrorCode(tU32 numberItemFromBegin);

protected:
   //! default constructor
   dia_EventLogger();
   //! class destructor
   virtual ~dia_EventLogger ( void );

   //! clear the content of the repository
   void destroy ( void );
   //!
   virtual size_t readMaxSizeOfList() const;

   //! list of commands managed by the controller
   std::list<dia_EventLog*> mEventRep;

   //! max number of item in the list
   size_t MaxNumberOfElem;

   //! convert char* to tU16
   virtual tU16 convertCharArrayToInt(const tS8* convertedStr);

private:
   //! undefined copy constructor
   dia_EventLogger(dia_EventLogger& obj);                // do not give these a body

   //undefined copy constructor
   dia_EventLogger(const dia_EventLogger& obj);          // do not give these a body

   //undefined assignment operator
   dia_EventLogger& operator = (const dia_EventLogger&); // do not give these a body
};

#endif
