/**
 * \file      dia_EventLog.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    kaa1hi
 * \date      Mar 7, 2014
 *
 * \copyright Robert Bosch Car Multimedia 2014
 */

#ifndef __INCLUDED_DIA_EVENT_LOG__
#define __INCLUDED_DIA_EVENT_LOG__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif


//-----------------------------------------------------------------------------

class dia_EventLog
{
private:
   static const tU16 MaxTimestampLength = sizeof("2014:01:01_00:00:00");

protected:
   //! number of alive objects
   static tU32 objCnt;
   //! timestamp from OS (in seconds)
   struct timeval mTV;
   //! file name (e.g. "dia_EventLog.cpp") based on absolute path (it is cut)
   tS8* mpFilename;
   //! timestamp buffer, e.g. "2014:01:01_00:00:00"
   tS8 mpTimestamp[MaxTimestampLength];
   // 16-bit error code
   tU16 mErrCode;
   // 16-bit line number (if number is bigger than 2^16-1 take 0 instead)
   tU16 mLineNumber;

public:
   //! class constructor
   dia_EventLog ( const tS8* timestamp, char* mpFilename, tU16 errCode, tU16 lineNumber );
   //! class destructor
   virtual ~dia_EventLog (void);
   //! dump the event (used by TTFis)
   virtual void Dump (void);
   //! useful for unit testing
   virtual tU16 GetErrorCode (void) const;
   //! get number of alive object (useful for unit testing)
   static tU32 GetObjCnt() { return objCnt; }

private:
   //! undefined default class constructor
   dia_EventLog();                                 // do not give these a body

   //! undefined copy constructor
   dia_EventLog(dia_EventLog& obj);                // do not give these a body

   //undefined copy constructor
   dia_EventLog(const dia_EventLog& obj);          // do not give these a body

   //undefined assignment operator
   dia_EventLog& operator = (const dia_EventLog&); // do not give these a body
};

#endif /* __INCLUDED_DIA_EVENT_LOG__ */
