/**
 * \file      dia_EventLog.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    kaa1hi
 * \date      Mar 7, 2014
 *
 * \copyright Robert Bosch Car Multimedia 2014
 */

#ifndef __INCLUDED_DIA_EVENT_LOG__
#include "common/framework/application/dia_EventLog.h"
#endif

#include <sys/time.h>   //gettimeofday
#include <errno.h>      //errno


#define MAX_LENGTH_OF_FILENAME (256)

//! Object counter for this class
tU32 dia_EventLog::objCnt(0);

//-----------------------------------------------------------------------------

dia_EventLog::dia_EventLog ( const tS8* pTimestamp, char* pFilename, tU16 errCode, tU16 lineNumber )
{
   DIA_TR_INF("dia_EventLog::dia_EventLog pTimestamp=%s, mpFilename=%s, errCode=0x%04X, lineNumber=%d", pTimestamp, pFilename, errCode, lineNumber );

   ++objCnt;

   (void)strncpy( (char*)mpTimestamp, (const char*)pTimestamp, MaxTimestampLength );
   mpTimestamp[MaxTimestampLength-1] = 0; //added zero manually

   //get OS timestamp (in microseconds)
   if (0!=gettimeofday(&mTV, NULL))
   {
      DIA_TR_INF("dia_EventLog::dia_EventLog gettimeofday FAILED. errno = %d", errno );
   }

   mErrCode = errCode;
   mLineNumber = lineNumber;

   size_t len = strnlen((const char*)pFilename, (size_t)MAX_LENGTH_OF_FILENAME );

   mpFilename = new tS8[len + 1];

   if (NULL!=mpFilename)
   {
      (void)strncpy( (char*)mpFilename, (const char*)pFilename, len );
      mpFilename[len] = 0; //added zero manually
   }
   else
   {
      DIA_TR_INF("dia_EventLog::dia_EventLog Heap full. No memory. pTimestamp=%s", pTimestamp );
   }
}

//-----------------------------------------------------------------------------

dia_EventLog::~dia_EventLog ( void )
{
   DIA_TR_INF("dia_EventLog::~dia_EventLog mpFilename=%s", mpFilename );
   delete [] mpFilename;
   mpFilename = NULL;

   --objCnt;
}

void dia_EventLog::Dump (void)
{
   DIA_TR_INF("mTV=%09ld.%06ld, pTimestamp=%s, errCode=0x%04X, lineNumber=%d", mTV.tv_sec, mTV.tv_usec, mpTimestamp, mErrCode, mLineNumber );
}

tU16 dia_EventLog::GetErrorCode (void) const
{
   DIA_TR_INF("dia_EventLog mErrCode=0x%04X", mErrCode );
   return mErrCode;
}

