/**
 * \file      dia_Command.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      Sep 27, 2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_COMMAND__
#define __INCLUDED_DIA_COMMAND__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_PREDICATE__
#include <common/framework/application/dia_Predicate.h>
#endif

#ifndef __INCLUDED_DIA_FUNCTOR__
#include <common/framework/application/dia_Functor.h>
#endif

//-----------------------------------------------------------------------------

namespace dia {

class Command
{
public:
   //! class constructor
   Command ( void );
   //! class destructor
   virtual ~Command ( void );

   //! add a predicate to the command
   virtual tDiaResult addPredicate ( dia_Predicate* pPredicate );
   //! find the given predicate
   virtual dia_Predicate* queryPredicate ( dia_UID predicateID );
   //! return number of predicates
   virtual size_t getNumOfPredicates ( void ) const { return mpPredicateRep.size(); }

   //! add a functor to the command
   virtual tDiaResult addFunctor ( dia_Functor* pFunctor );

   //! update all predicates attached to this command
   virtual void update ( void );
   //! update the predicate with the given ID
   virtual void update ( dia_UID id );

   //! check if the command is ready to be executed
   virtual tBool isReady ( void );

   //! execute the request
   virtual tDiaResult execute ( void );

protected:
   //! list of predicates attached to this command
   std::map<UID,dia_Predicate*> mpPredicateRep;
   //! list of predicates attached to this command
   std::list<dia_Functor*> mFunctorRep;

private:
    //! destroy command contents
    void destroy ( void );
};

}

// for backward compatibility
typedef dia::Command dia_Command;

#endif /* __INCLUDED_DIA_COMMAND__ */
