/**
 * \file      dia_Command.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      Sep 27, 2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_COMMAND__
#include <common/framework/application/dia_Command.h>
#endif

namespace dia {

//-----------------------------------------------------------------------------

Command::Command ( void )
{}

//-----------------------------------------------------------------------------

Command::~Command ( void )
{
   _BP_TRY_BEGIN
   {
      destroy();
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia::Command::~Command !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

void
Command::destroy ( void )
{
   DIA_IMPL_MAP_REPOSITORY_TEAR_DOWN(UID,dia_Predicate,mpPredicateRep);
   DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(dia_Functor,mFunctorRep);

}

//-----------------------------------------------------------------------------

tDiaResult
Command::addPredicate ( dia_Predicate* pPredicate )
{
   ScopeTrace trc("dia::Command::addPredicate()");

   tDiaResult retCode = DIA_FAILED;

   if ( pPredicate )
   {
      UID id = pPredicate->getUID();
      std::map<UID,dia_Predicate*>::iterator iter = mpPredicateRep.find(id);
      if ( iter == mpPredicateRep.end() )
      {
         mpPredicateRep[id] = pPredicate;
         retCode = DIA_SUCCESS;
      }
   }

   return retCode;
}

//-----------------------------------------------------------------------------

dia_Predicate*
Command::queryPredicate ( UID predicateID )
{
   dia_Predicate* pPredicate = 0;

   std::map<UID,dia_Predicate*>::iterator iter = mpPredicateRep.find(predicateID);
   if ( iter != mpPredicateRep.end() )
   {
      pPredicate = iter->second;
   }

   return pPredicate;
}

//-----------------------------------------------------------------------------

void
Command::update ( void )
{
   ScopeTrace trc("dia::Command::update()");

   std::map<UID,dia_Predicate*>::iterator iter = mpPredicateRep.begin();
   for ( ; iter != mpPredicateRep.end(); ++iter )
   {
      (void) iter->second->match();
   }
}

//-----------------------------------------------------------------------------

void
Command::update ( dia_UID id )
{
   ScopeTrace trc("dia::Command::update(ID)");

   std::map<UID,dia_Predicate*>::iterator iter = mpPredicateRep.find(id);
   if ( iter != mpPredicateRep.end() )
   {
      (void) iter->second->match();
   }
}

//-----------------------------------------------------------------------------

tBool
Command::isReady ( void )
{
   ScopeTrace trc("dia::Command::isReady()");

   tBool bRetCode = TRUE;

   std::map<UID,dia_Predicate*>::iterator iter = mpPredicateRep.begin();
   for ( ; iter != mpPredicateRep.end(); ++iter )
   {
      if ( iter->second->isMatched() == FALSE )
      {
         bRetCode = FALSE;
      }
      else
      {
         DIA_TR_INF("### Predicate Matched !!!");
      }
   }

   return bRetCode;
}

//-----------------------------------------------------------------------------

tDiaResult
Command::addFunctor ( dia_Functor* pFunctor )
{
   ScopeTrace trc("dia::Command::addFunctor()");

   if ( !pFunctor ) return DIA_FAILED;

   mFunctorRep.push_back(pFunctor);
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
Command::execute ( void )
{
   ScopeTrace trc("dia::Command::execute()");

   std::list<dia_Functor*>::iterator funcIter = mFunctorRep.begin();
   for ( ; funcIter != mFunctorRep.end(); ++funcIter )
   {
      (void) (*(*funcIter))();
   }

   return DIA_SUCCESS;
}

}
