/*
 * dia_BundleContainer.h
 *
 *  Created on: 06.09.2017
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_BUNDLE_CONTAINER__
#define __INCLUDED_DIA_BUNDLE_CONTAINER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_BUNDLE__
#include <common/framework/application/dia_Bundle.h>
#endif

namespace dia {

class BundleConfiguration;

class BundleContainer
   : public Bundle
{
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(BundleContainer);

public:
   BundleContainer ( BundleConfiguration& bundleConfig );
   virtual ~BundleContainer ( void );
   virtual tDiaResult initializeBundle(void);
   //! initialize only the given initialization level for this bundle
   virtual tDiaResult initializeBundle ( const InitializationLevel& initLevel );

   virtual void setInitialized ( bool value );

   //! if the bundle is an active object start the bundles main loop
   virtual tDiaResult startBundle ( void );

   virtual tDiaResult addBundle ( Bundle& bundle );

protected:
   BundleContainer ( void );
   bool mInitDone;

protected:
   std::map<UID,Bundle*> mBundleRep;
   std::list<Bundle*> mBundles;
};

}

#endif /* __INCLUDED_DIA_BUNDLE_CONTAINER__ */
