/*
 * dia_Bundle.h
 *
 *  Created on: 01.09.2017
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_BUNDLE__
#define __INCLUDED_DIA_BUNDLE__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

namespace dia {

class BundleConfiguration;
class InitializationLevel;

class Bundle
   : public ObjectWithUID
{
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(Bundle);

public:
   Bundle ( BundleConfiguration& bundleConfig );
   virtual ~Bundle ( void );

   virtual tDiaResult initializeBundle ( void ){ return DIA_SUCCESS; }
   //! initialize the given list of initialization levels for this bundle
   virtual tDiaResult initializeBundle ( const std::list<InitializationLevel*>& initLevels );
   //! initialize only the given initialization level for this bundle
   virtual tDiaResult initializeBundle ( const InitializationLevel& initLevel ) = 0; //{ return DIA_SUCCESS; }
   //! finalize all initialization levels for this bundle
   virtual tDiaResult finalizeBundle ( const std::list<InitializationLevel*>& initLevels );
   //! finalize only the given initialization level for this bundle
   virtual tDiaResult finalizeBundle ( const InitializationLevel& )  { return /*DIA_SUCCESS*/ DIA_E_NOT_IMPLEMENTED; }

   //! if the bundle is an active object start the bundles main loop
   virtual tDiaResult startBundle ( void ) { mIsStarted = true; return DIA_SUCCESS; }
   //! if the bundle is an active object stops the bundles main loop
   virtual tDiaResult stopBundle ( void ) { return /*DIA_SUCCESS*/ DIA_E_NOT_IMPLEMENTED; }

   virtual void setInitialized ( bool value ) { mIsInitialized = value; }

   bool isConfigurationValid ( void ) const { return mIsConfigValid; }
   bool isInitialized ( void ) const { return mIsInitialized; }
   bool isStarted ( void ) const { return mIsStarted; }

protected:
   Bundle ( void );

protected:
   //! configuration object for this bundle
   BundleConfiguration* mpConfig;
   bool mIsConfigValid;
   bool mIsInitialized;
   bool mIsStarted;
};

}
#endif /* __INCLUDED_DIA_BUNDLE__ */
