/*!
 * \file       dia_ApplicationLock.cpp
 *
 * \brief      Central Mutex Lock for application
 *
 * \component  Diagnostics
 *
 * \ingroup    diaCoreAppFrw
 *
 * \copyright  (c) 2019 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
#include <common/framework/application/dia_ApplicationLock.h>

namespace dia{

ApplicationLock* ApplicationLock::mpInstance = nullptr;

ApplicationLock*
createInstanceOfApplicationLock ( void )
{
   return ApplicationLock::createInstance();
}

//---------------------------------------------------------------------------------------------------------------------

ApplicationLock*
getInstanceOfApplicationLock ( void )
{
   return ApplicationLock::getInstance();
}

//---------------------------------------------------------------------------------------------------------------------

void
releaseInstanceOfApplicationLock ( void )
{
   ScopeTrace oTrace("releaseInstanceOfApplicationLock");
   ApplicationLock::deleteInstance();
}


//---------------------------------------------------------------------------------------------------------------------

ApplicationLock*
ApplicationLock::createInstance ( void )
{

   if ( !mpInstance )
   {
      mpInstance = new (std::nothrow) ApplicationLock;
      if ( mpInstance )
      {
          DIA_TR_INF("Created Application Lock");
      }
   }

   return mpInstance;
}

//---------------------------------------------------------------------------------------------------------------------

ApplicationLock*
ApplicationLock::getInstance ( void )
{
   return mpInstance;
}

//---------------------------------------------------------------------------------------------------------------------

void
ApplicationLock::deleteInstance ( void )
{
   if ( mpInstance )
   {
      delete mpInstance;
      mpInstance = nullptr;
   }
}

}
