/*!
 * \file       dia_Application.h
 *
 * \brief      This file contains the definition of the dia_Application class
 *             that encapsulate all parts of the diagnosis application
 *
 * \details    This file contains the definition of the dia_Application class
 *             that encapsulate all parts of the diagnosis application
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreAppFrw
 *
 * \copyright  (c) 2012-2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_APPLICATION__
#define __INCLUDED_DIA_APPLICATION__

#ifndef __INCLUDED_DIA_DIAGSESSION__
#include "common/depricated/dia_tclDiagSession.h"
#endif

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_DIAGSESSION__
#include "common/depricated/dia_tclDiagSession.h"
#endif

// forward declarations
//class dia_tclDiagSession::tclEvent;

enum enMsgProcID
{
   enMsgProcID_Unknown = 0,
   enMsgProcID_WorkerCCA,
   enMsgProcID_WorkerUDS,
   enMsgProcID_COUNT
};

/**
 * \class   dia_Application
 *
 * \brief   This file encapsulates all parts of the diagnosis application. It
 *          controls startup, shutdown and the configuration of the diagnosis
 *          component
 *
 * \ingroup diaCoreAppFrw
 */

class dia_Application
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_Application);

public:
   //! class destructor
   virtual ~dia_Application ( void );

   //! setup method for the application
   virtual tDiaResult setup ( void ) const;
   //! shutdown method for the application
   virtual tDiaResult shutdown ( void ) const;

//   //! post a message to the application
//   tDiaResult postMessage ( const dia_Message& message );

   // temporarily
   virtual void postMessage ( dia_tclDiagSession::tclEvent* pEvent ) const;
   virtual tBool postMessage ( tU32 pEvent ) const;
//
//   //! add a message processor
//   tDiaResult addMessageProcessor ( enMsgProcID id, dia_MessageProcessor& proc );
//   //! retrieve a pointer to the message processor with the given identifier
//   tDiaResult queryMessageProcessor ( enMsgProcID id, dia_MessageProcessor** ppProc );

   // null response (fabricates a confirmation without sending the response to the tester)
   static void vNullResponse ( const tU8*, tU16, tCookieType );

protected:
   //! class constructor
   dia_Application ( void );

private:
   //! map of message processors
// std::map<enMsgProcID,dia_MessageProcessor*> mMsgProcRep;
};

#endif /* __INCLUDED_DIA_APPLICATION__ */

