/*
 * dia_ActiveObject.h
 *
 *  Created on: 22.05.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDE_DIA_ACTIVE_OBJECT__
#define __INCLUDE_DIA_ACTIVE_OBJECT__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include <common/framework/config/dia_defsConfig.h>
#endif

#ifdef VARIANT_S_FTR_ENABLE_THREAD_AS_PTHREAD_THREAD
#include <unistd.h>
#include <pthread.h>
#endif


typedef void (*dia_ThreadEntrypoint) (void*);

class dia_ActiveObject
{
   friend class dia_RoutineCtrlChecksum;

public:
   //! class constructor
   dia_ActiveObject ( tCString name, tU32 propPrio=DIA_PROP_INVALID_IDENTIFIER, tU32 propStackSize=DIA_PROP_INVALID_IDENTIFIER );
   //! class destructor
   virtual ~dia_ActiveObject ( void );

protected:
   //! deprecated class constructor (no implementation)
   dia_ActiveObject ( void );

#ifdef VARIANT_S_FTR_ENABLE_THREAD_AS_PTHREAD_THREAD
   //! thread entrypoint method
   static void* vThreadEntrypoint ( void* pObj );
#else
   static void vThreadEntrypoint ( void* pObj );
#endif

   //! object specific thread function
   virtual void vThreadEntrypointObject ( void ) = 0;
   //! initialization of the thread
   virtual void vThreadInitialize ( void );
   //! finalization of the thread
   virtual void vThreadFinalize ( void );

   //! spawn the active objects thread
   virtual tDiaResult startThread ( void );
   //! spawn the active objects thread
   virtual tDiaResult terminateThread ( void );

   //! retrieve the priority for the active objects thread
   virtual tU32 getThreadPriority ( void ) const;
   //! retrieve the priority for the active objects thread
   virtual tU32 getStackSize ( void ) const;

#ifdef VARIANT_S_FTR_ENABLE_THREAD_AS_PTHREAD_THREAD
   virtual pthread_t getThreadID(void) const { return mThreadID; }
#else
   virtual OSAL_tThreadID getThreadID(void) const { return mThreadID; }
#endif

protected:
   //! name of the active object
   tCString mThreadName;
   //! thread priority
   tU32 mPropThreadPrio;
   //! thread priority
   tU32 mPropThreadStackSize;
   //! thread identifier
#ifdef VARIANT_S_FTR_ENABLE_THREAD_AS_PTHREAD_THREAD
   pthread_t mThreadID;
   pthread_attr_t mThreadAttr;
#else
   OSAL_tThreadID mThreadID;
#endif
};

#endif /* __INCLUDE_DIA_ACTIVE_OBJECT__ */
